package io.github.devsecops.engine.mojos.artifact;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.core.model.Pom;
import io.github.devsecops.engine.core.resolver.strategy.Resolver;
import io.github.devsecops.engine.mojos.artifact.instructions.*;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployArtifactCommand implements Command {
    private static final String MAVEN_SETTINGS = "MAVEN_SETTINGS";
    @Autowired
    private Executor executor;
    @Setter
    private ArtifactRepositoryType repositoryType;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        if (ArtifactRepositoryType.RELEASE.equals(repositoryType)) {
            Pom.getINSTANCE().removeQualifierFromVersion();
        }
        Instruction clean = MavenCleanInstruction.builder().settings(resolver.resolve(MAVEN_SETTINGS)).build();
        Instruction deploy = MavenDeployArtifactInstruction.builder().settings(resolver.resolve(MAVEN_SETTINGS)).build();
        Instruction java = JavaPathInstruction.builder().build();
        InstructionInvoker.init(executor).append(java)
                .append(clean).append(deploy)
                .execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}
