package io.github.devsecops.engine.mojos.artifact;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.core.model.GitVariables;
import io.github.devsecops.engine.core.model.Pom;
import io.github.devsecops.engine.core.resolver.strategy.Resolver;
import io.github.devsecops.engine.mojos.artifact.instructions.*;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitCommitAndPushPomCommand implements Command {

    @Autowired
    private Executor executor;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        Instruction init = GitInitConfigInstruction.builder().build();
        Instruction push = GitPushInstruction.builder()
                .username(resolver.resolve(GitVariables.GIT_USER_NAME.getName()))
                .password(resolver.resolve(GitVariables.GIT_PASSWORD.getName()))
                .gitUrlTemplate(resolver.resolve(GitVariables.GIT_URL.getName())).build();
        Instruction commit = GitPomCommitInstruction.builder().build();
        InstructionInvoker.init(executor).append(init).append(push).append(commit).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}
