package io.github.devsecops.engine.mojos.artifact.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Builder
@AllArgsConstructor
public class GitPomCommitInstruction implements Instruction {

    private static final String CMD =
            "git add %s && " +
            "git checkout . && " +
            "git checkout %s && " +
            "git commit -m \"%s\"";

    private static final String POM_FILE = "pom.xml";
    private static final String COMMIT_MESSAGE = "Increasing version post release";
    private static final String GIT_BRANCH = "DEVELOP";

    @Override
    public String getCmd() {
        return String.format(CMD, POM_FILE, GIT_BRANCH, COMMIT_MESSAGE);
    }
}
