package io.github.devsecops.engine.mojos.artifact.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Builder
@AllArgsConstructor
public class GitPushInstruction implements Instruction {

    private static final String CMD =
            "git config http.sslVerify false && " +
            "git remove set-url origin \"%s\" && " +
            "git push origin --tags && " +
            "git git push origin";

    private String username;
    private String password;
    private String gitUrlTemplate;
    @Override
    public String getCmd() {
        String gitUrl = null;
        try {
            gitUrl = String.format(gitUrlTemplate, username, URLEncoder.encode(password, StandardCharsets.UTF_8.toString()));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Couldn't encode password prior pushing to git");
        }
        return String.format(CMD, gitUrl);
    }
}
