package io.github.devsecops.engine.domain.artifact.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.pom.model.Pom;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.artifact.instructions.MavenDeployArtifactInstruction;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployArtifactCommand implements Command {
    private static final String MAVEN_SETTINGS = "MAVEN_SETTINGS";
    private static final String JAVA_HOME = "JAVA_HOME";
    @Autowired
    private Executor executor;
    @Setter
    private ArtifactRepositoryType repositoryType;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        if (ArtifactRepositoryType.RELEASE.equals(repositoryType)) {
            Pom.getINSTANCE().removeQualifierFromVersion();
        }
        Instruction clean = io.github.devsecops.engine.domain.artifact.instructions.MavenCleanInstruction.builder().settings(resolver.resolve(MAVEN_SETTINGS)).build();
        Instruction deploy = MavenDeployArtifactInstruction.builder().settings(resolver.resolve(MAVEN_SETTINGS)).build();
        InstructionInvoker.init(executor).append(clean).append(deploy).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}
