package io.github.devsecops.engine.domain.artifact.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

@Builder
@AllArgsConstructor
public class JavaPathInstruction implements Instruction {
    private static final String CMD = "export JAVA_HOME=%s";
    private final String javaHome;
    @Override
    public String getCmd() {
        return String.format(CMD, javaHome);
    }
}
