package io.github.devsecops.engine.domain.docker.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.docker.instructions.DockerBuildImageInstruction;
import io.github.devsecops.engine.domain.docker.instructions.DockerLoginInstruction;
import io.github.devsecops.engine.domain.docker.instructions.DockerPushImageInstruction;
import io.github.devsecops.engine.domain.docker.model.DockerVariables;
import io.github.devsecops.engine.domain.pom.model.Pom;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildImageCommand implements Command {
    @Autowired
    private Executor executor;
    @Setter
    private ArtifactRepositoryType repositoryType;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        String imageSuffix = "";
        if (repositoryType != null) {
            imageSuffix = ArtifactRepositoryType.RELEASE.equals(repositoryType) ? "-release" : "-snapshot";
        }
        Instruction login = DockerLoginInstruction.builder().password(resolver.resolve(DockerVariables.DOCKER_HUB_PASSWORD.getName())).build();
        Instruction build = DockerBuildImageInstruction.builder().imageUrl(resolver.resolve(DockerVariables.DOCKER_IMAGE_FULL_URL.getName())).type(imageSuffix).build();
        Instruction push = DockerPushImageInstruction.builder().imageUrl(resolver.resolve(DockerVariables.DOCKER_IMAGE_FULL_URL.getName())).type(imageSuffix).build();
        InstructionInvoker.init(executor).append(login).append(build).append(push).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}
