package io.github.devsecops.engine.domain.genconfig.commands;

import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.resolver.utils.TokenReplacement;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractConfigCommand implements Command {
    public abstract String getTemplatePath();
    public abstract String getOutputPath();

    @Getter
    @Setter
    private Environment env;

    @Autowired
    private TokenReplacement tokenReplacement;

    public void execute() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get(getTemplatePath()));
        final List<String> replacedLines = lines.stream().map(line -> tokenReplacement.replace(line)).collect(Collectors.toList());
        Files.write(Paths.get(getOutputPath()), replacedLines);
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("Nothing to rollback when generating a config file");
    }
}
