package io.github.devsecops.engine.domain.pom.model;

import io.github.devsecops.engine.domain.pom.utils.SemanticVersionMapper;
import io.github.devsecops.engine.domain.pom.utils.PomModelUtils;
import lombok.Getter;
import org.apache.maven.model.Model;

import java.util.Optional;

@Getter
public class Pom {

    private static Pom INSTANCE;

    public static Pom getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new Pom();
        }
        return INSTANCE;
    }
    private final String groupId;
    private final String artifactId;
    private String version;
    private final Model model;

    private Pom() {
        this.model = PomModelUtils.read();
        this.groupId = model.getGroupId();
        this.artifactId = model.getArtifactId();
        this.version = model.getVersion();
    }

    public void removeQualifierFromVersion() {
        updateVersion(version.replace("-SNAPSHOT", ""));
    }

    public String getJarNam() {
        return String.format("%s-%s.jar", artifactId, version);
    }
    public Optional<SemanticVersion> getSemanticVersion() {
        return version == null? Optional.empty() : SemanticVersionMapper.toSemanticVersion(version);
    }
    public Long snapshotsCount() {
        Long count = this.model.getDependencies().parallelStream().filter(d -> isSnapshot(d.getVersion())).count();
        count += this.model.getBuild().getPlugins().parallelStream().filter(p -> isSnapshot(p.getVersion())).count();
        return count;
    }

    private boolean isSnapshot(String version) {
        return version.contains("SNAPSHOT");
    }

    public void updateVersion(String version) {
        this.version = version;
        final Model model = PomModelUtils.read();
        model.setVersion(version);
        PomModelUtils.update(model);

    }
}
