package io.github.devsecops.engine.domain.resolver.utils;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Auth;
import com.bettercloud.vault.response.AuthResponse;

public class VaultBuilder {

    private static final int ENGINE_VERSION = 2;
    private static final int OPEN_TIMEOUT = 5;
    private static final int READ_TIMEOUT = 30;

    public static Vault newVault(final String url, final String roleId, final String secretId) throws VaultException {
        final VaultConfig vaultConfig = new VaultConfig()
                .address(url)
                .openTimeout(OPEN_TIMEOUT)
                .readTimeout(READ_TIMEOUT)
                .sslConfig(new SslConfig().verify(Boolean.FALSE).build())
                .engineVersion(ENGINE_VERSION)
                .build();
        AuthResponse authResponse = (new Auth(vaultConfig)).loginByAppRole(roleId, secretId);
        vaultConfig.token(authResponse.getAuthClientToken());
        return new Vault(vaultConfig);
    }

}
