package io.github.devsecops.engine.domain.sonar.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

@Builder
@AllArgsConstructor
public class SonarAnalysisInstruction implements Instruction {

    private static final String COMMAND = "mvn clean install sonar:sonar " +
            "-Dsonar.host.url=%s " +
            "-Dsonar.login=%s " +
            "-Dsonar.projectKey=%s";

    private String sonarUrl;
    private String loginKey;
    private String projectKey;

    @Override
    public String getCmd() {
        return String.format(COMMAND, sonarUrl, loginKey, projectKey);
    }

}
