package io.github.devsecops.engine.core;

import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Invoker;

import java.util.Stack;

public class CommandInvoker implements Invoker {
    private Stack<Command> pendingCommands;
    private Stack<Command> executedCommands;
    private Log log;

    public CommandInvoker(Stack<Command> pendingQueues, Log log) {
        this.pendingCommands = pendingQueues;
        this.executedCommands = new Stack<>();
        this.log = log;
    }

    @Override
    public void execute() throws Exception {
        try {
            while(!pendingCommands.empty()) {
                Command command = pendingCommands.pop();
                executedCommands.push(command);
                command.execute();
            }
        } catch (Exception e) {
            log.error(e);
            log.info("Roolback");
            rollback();
            throw e;
        }
    }

    private void rollback() {
        try {
            while(!executedCommands.empty()) {
                Command command = executedCommands.pop();
                command.rollback();
            }
        } catch (Exception e) {
            log.error(e);
        }
    }
}
