package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

@Builder
@AllArgsConstructor
public class DockerBuildImageInstruction implements Instruction {
    private static final String CMD = "docker build " +
            "--force-rm " +
            "--no-cache " +
            "--build-arg PRIVATE_KEY_PASSWORD=%s " +
            "--build-arg SERVICE_PORT=%s " +
            "--build-arg ARTIFACT_URL=%s " +
            "-t %s%s " +
            "-f ./ci/build/Dockerfile .";
    private final String imageUrl;
    private final String type;
    private final String passphrase;
    private final String artifactUrl;
    private final String port;

    @Override
    public String getCmd() {
        return String.format(CMD, passphrase, port, artifactUrl, imageUrl, type);
    }
    public String getType() {
        return type;
    }
}
