package io.github.devsecops.engine.domain.git.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.git.model.GitVariables;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.git.instructions.GitPomCommitInstruction;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitCommitAndPushPomCommand implements Command {

    @Autowired
    private Executor executor;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        Instruction init = io.github.devsecops.engine.domain.git.instructions.GitInitConfigInstruction.builder().username(resolver.resolve(GitVariables.GIT_USER_NAME.getName()))
                .password(resolver.resolve(GitVariables.GIT_PASSWORD.getName()))
                .gitUrlTemplate(resolver.resolve(GitVariables.GIT_URL.getName())).build();
        Instruction push = io.github.devsecops.engine.domain.git.instructions.GitPushInstruction.builder().build();
        Instruction commit = GitPomCommitInstruction.builder().build();
        InstructionInvoker.init(executor).append(init).append(commit).append(push).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for artifact commands");
    }
}
