package io.github.devsecops.engine.domain.pom.utils;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import javax.net.ssl.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JarFullPathRetriever {

    public static void main(String[] args) {
        System.out.println(JarFullPathRetriever.retrieve("https://s01.oss.sonatype.org/service/local/repositories/snapshots/content/io/github/devsecops-zone/iam-api/2.0.1-SNAPSHOT/"));
    }
    public static String retrieve(String urlName) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(new KeyManager[0], new TrustManager[] {new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(context);

            URL url = new URL(urlName);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setHostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });

            InputStream is =(InputStream) connection.getContent();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);

            final XPathFactory xPathFactory = XPathFactory.newInstance();
            final XPath xPath = xPathFactory.newXPath();
            final XPathExpression expression = xPath.compile("//resourceURI");
            String jarFullPath = "";

            NodeList list = (NodeList) expression.evaluate(doc, XPathConstants.NODESET);
            List<String> result = new ArrayList<>();
            for (int i = 0; i < list.getLength(); i++) {
                String resourceURI = list.item(i).getTextContent();
                if (!resourceURI.endsWith("sources.jar") && !resourceURI.endsWith("javadoc.jar") && resourceURI.endsWith("jar")) {
                    result.add(resourceURI);
                }
            }

            connection.disconnect();
            if (result.size() == 0) {
                throw new Exception();
            }
            Collections.sort(result, Collections.reverseOrder());
            return result.get(0);
        } catch (Exception e) {
            return "Cannot retrieve version from metadata from url: " + urlName;
        }
    }

    private static class DefaultTrustManager implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }
        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}
