package io.github.devsecops.engine.domain.resolver.path;

import static com.google.common.collect.ImmutableMap.of;

import io.github.devsecops.engine.domain.resolver.model.PathCompose;
import io.github.devsecops.engine.domain.resolver.model.PathList;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;
import java.util.Map;

import static io.github.devsecops.engine.core.model.Environment.*;

@Configuration
public class PathListConfig {

    @Qualifier("PathList")
    @Bean
    public Map<String, PathList> getMap() {
        return of(
                LOCAL.name(), getFromVar("local"),
                DEV.name(), getFromVar("dev"),
                UAT.name(), getFromVar("uat")
        );
    }

    private PathList getFromVar(String environment) {
        return new PathList(Arrays.asList(
                newResourcePropertyFile("infra"),
                newResourcePropertyFile("vault"),
                newResourcePropertyFile("db"),
                newResourcePropertyFile("docker"),
                newResourcePropertyFile("nexus"),
                newResourcePropertyFile("git"),
                newResourcePropertyFile("sonar"),
                newPropertyFile("default"),
                newPropertyFile(environment)
        ));
    }

    private PathCompose newResourcePropertyFile(final String propertyFileName) {
        return PathCompose.builder()
                .path(String.format("/vars/%s.properties", propertyFileName))
                .resource(true)
                .build();
    }

    private PathCompose newPropertyFile(final String propertyFileName) {
        return PathCompose.builder()
                .path(String.format("./ci/vars/%s.properties", propertyFileName))
                .build();
    }

}
