package io.github.devsecops.engine.domain.resolver.path;

import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.domain.resolver.model.PathList;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.resolver.strategy.ResolverStrategy;
import io.github.devsecops.engine.domain.resolver.strategy.impl.EnvironmentResolverStrategy;
import io.github.devsecops.engine.domain.resolver.strategy.impl.PropertyFileResolverStrategy;
import io.github.devsecops.engine.domain.resolver.strategy.impl.VaultResolverStrategy;
import io.github.devsecops.engine.domain.resolver.utils.VaultBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Map;

import static io.github.devsecops.engine.domain.resolver.model.VaultVariables.VAULT_APP_PATH;
import static io.github.devsecops.engine.domain.resolver.model.VaultVariables.VAULT_ROLE_ID;
import static io.github.devsecops.engine.domain.resolver.model.VaultVariables.VAULT_SECRET_ID;
import static io.github.devsecops.engine.domain.resolver.model.VaultVariables.VAULT_URL;

@Service
public class PathResolverBuilder implements Factory<Resolver> {

    @Autowired
    private Log logger;

    @Autowired
    @Qualifier("PathList")
    private Map<String, PathList> pathListMap;

    private PathList getPathList(Map<String, String> parameters) {
        return pathListMap.get(parameters.get(BuildParam.ENV.name()).toUpperCase());
    }

    @Override
    public Resolver build(Map<String, String> parameters) throws Exception {
        final PathList pathList = this.getPathList(parameters);
        final ResolverStrategy propertiesResolver = new PropertyFileResolverStrategy(pathList);
        final ResolverStrategy environmentResolver = new EnvironmentResolverStrategy();
        final ResolverStrategy vaultStrategyResolver = new VaultResolverStrategy(
                VaultBuilder.newVault(
                        propertiesResolver.resolve(VAULT_URL.getName()).orElse(null),
                        environmentResolver.resolve(VAULT_ROLE_ID.getName()).orElse(null),
                        environmentResolver.resolve(VAULT_SECRET_ID.getName()).orElse(null)
                ), propertiesResolver.resolve(VAULT_APP_PATH.getName()).orElse(null));
        return new Resolver(propertiesResolver, environmentResolver, vaultStrategyResolver, logger);
    }


}
