package io.github.devsecops.engine.domain.sonar.commands;

import io.github.devsecops.engine.core.InstructionInvoker;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Executor;
import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.sonar.instructions.SonarAnalysisInstruction;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static io.github.devsecops.engine.domain.sonar.model.SonarVariables.SONAR_COMPONENT;
import static io.github.devsecops.engine.domain.sonar.model.SonarVariables.SONAR_LOGIN_KEY;
import static io.github.devsecops.engine.domain.sonar.model.SonarVariables.SONAR_URL;

@Component
public class SonarAnalysisCommand implements Command {

    @Autowired
    private Executor executor;
    @Setter
    private Resolver resolver;

    @Override
    public void execute() throws Exception {
        Instruction sonarAnalysis = SonarAnalysisInstruction.builder()
                .sonarUrl(resolver.resolve(SONAR_URL.getName()))
                .loginKey(resolver.resolve(SONAR_LOGIN_KEY.getName()))
                .projectKey(resolver.resolve(SONAR_COMPONENT.getName()))
                .build();
        InstructionInvoker.init(executor).append(sonarAnalysis).execute();
    }

    @Override
    public void rollback() throws Exception {
        throw new UnsupportedOperationException("No rollback is specified for sonar analysis commands");
    }

}
