package io.github.devsecops.engine.domain.sonar.model;

import io.github.devsecops.engine.core.model.PropertyVariables;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
public enum SonarVariables implements PropertyVariables {

    SONAR_URL("sonar.url"),
    SONAR_LOGIN("sonar.login"),
    SONAR_LOGIN_KEY("sonar.loginKey"),
    SONAR_PASSWORD("sonar.password"),
    SONAR_COMPONENT("sonar.componentKey"),
    SONAR_MAX_RELIABILITY_RATING("sonar.maxReliabilityRating"),
    SONAR_MAX_BUGS("sonar.maxBugs"),
    SONAR_SECURITY_RATING("sonar.securityRating"),
    SONAR_MAX_VULNERABILITIES("sonar.maxVulnerabilities"),
    SONAR_MAX_MAINTAINABILITY_RATING("sonar.maxMaintainabilityRating"),
    SONAR_MAX_CODE_SMELLS("sonar.maxCodeSmells"),
    SONAR_MIN_COVERAGE("sonar.minCoverage"),
    SONAR_MAX_DUPLICATIONS("sonar.maxDuplications");

    @Getter
    private String name;
}
