package io.github.devsecops.engine.mojos.image;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.BuildParam;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.artifact.commands.DeployArtifactCommand;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import io.github.devsecops.engine.domain.docker.commands.BuildImageCommand;
import io.github.devsecops.engine.domain.git.commands.GitCommitAndPushPomCommand;
import io.github.devsecops.engine.domain.pom.commands.PomIncreaseVersionCommand;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;

@Service
public class BuildImageFactory implements Factory<Invoker> {

    private static final List<Environment> RELEASES_ENV = Arrays.asList(Environment.UAT);

    @Autowired
    private Log logger;

    @Autowired
    private PathResolverBuilder pathResolverFactory;

    @Autowired
    private BuildImageCommand buildImageCommand;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        final Resolver resolver = pathResolverFactory.build(parameters);

        Environment env = getEnv(parameters);
        ArtifactRepositoryType repositoryType = getRepositoryType(env);

        buildImageCommand.setRepositoryType(repositoryType);
        buildImageCommand.setResolver(resolver);
        buildImageCommand.setEnv(env);

        Stack<Command> commands = new Stack<>();
        commands.push(buildImageCommand);
        return new CommandInvoker(commands, logger);
    }

    private ArtifactRepositoryType getRepositoryType(Environment env) {
        return env == null ? null : RELEASES_ENV.contains(env) ? ArtifactRepositoryType.RELEASE : ArtifactRepositoryType.SNAPSHOT;
    }

    private Environment getEnv(Map<String, String> parameters) {
        String env = parameters.get(BuildParam.ENV.name());
        return StringUtils.isEmpty(env) || "local".equalsIgnoreCase(env) ? null : Environment.valueOf(env.toUpperCase());
    }
}
