package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

@Builder
@AllArgsConstructor
public class DockerLoginInstruction implements Instruction {
    private static final String CMD = "echo \"%s\" | docker login --username devsecops2021 --password-stdin";
    private final String password;

    @Override
    public String getCmd() {
        return String.format(CMD, password);
    }
}
