package io.github.devsecops.engine.domain.docker.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import io.github.devsecops.engine.domain.artifact.model.ArtifactRepositoryType;
import lombok.AllArgsConstructor;
import lombok.Builder;

@Builder
@AllArgsConstructor
public class DockerPushImageInstruction implements Instruction {
    private static final String CMD = "docker push %s%s || exit 1";
    private final String imageUrl;
    private final String type;

    @Override
    public String getCmd() {
        return String.format(CMD, imageUrl, type);
    }
}
