package io.github.devsecops.engine.domain.git.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Builder
@AllArgsConstructor
public class GitInitConfigInstruction implements Instruction {
    private static final String CMD =
            "git config --global user.email \"mustapha.senhaji.87@gmail.com\" && " +
            "git config --global user.name \"Jenkins Automated Agent\" && " +
                    "git config http.sslVerify false && " +
                    "git remote set-url origin \"%s\" && " +
            "git config remote.origin.fetch '+refs/heads/*:refs/remotes/origin/*' && " +
            "git fetch --all";

    private String username;
    private String password;
    private String gitUrlTemplate;

    @Override
    public String getCmd() {
        String gitUrl = null;
        try {
            gitUrl = String.format(gitUrlTemplate, username, URLEncoder.encode(password, StandardCharsets.UTF_8.toString()));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Couldn't encode password prior pushing to git");
        }
        return String.format(CMD, gitUrl);
    }
}
