package io.github.devsecops.engine.domain.sonar.api;

import com.google.common.collect.ImmutableMap;
import io.github.devsecops.engine.domain.sonar.model.Metric;
import io.github.devsecops.engine.domain.sonar.utils.SonarMeasureMapper;
import org.sonar.wsclient.SonarClient;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.lang.String.join;
import static java.util.Arrays.asList;

public class SonarMeasuresApi {

    private static final String METRIC_REST_ENDPOINT = "api/measures/component";

    private final SonarClient sonarClient;
    private final SonarMeasureMapper mapper;

    public SonarMeasuresApi(SonarClient sonarClient) {
        this.sonarClient = sonarClient;
        this.mapper = new SonarMeasureMapper();
    }

    public Map<Metric, Integer> calculate(final String component) {
        final List<String> metrics = asList(Metric.values()).stream().map(Metric::getName).collect(Collectors.toList());
        final Map<String, Object> params = ImmutableMap.of(
                "component", component,
                "metricKeys", join(",", metrics)
        );
        final String response = sonarClient.get(METRIC_REST_ENDPOINT, params);
        return mapper.toMeasures(response);
    }

}
