package io.github.devsecops.engine.mojos.genconfig;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.core.model.Environment;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.utils.TokenReplacement;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.genconfig.commands.AbstractConfigCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Stack;

import static io.github.devsecops.engine.core.model.BuildParam.ENV;

@Service
public class GenConfigFactory implements Factory<Invoker> {

    @Autowired
    private Log logger;
    @Autowired
    private PathResolverBuilder pathResolverFactory;
    @Autowired
    private TokenReplacement tokenReplacement;

    @Autowired
    @Qualifier("YAML")
    private io.github.devsecops.engine.domain.genconfig.commands.AbstractConfigCommand yamlGenConfigFile;

    @Autowired
    @Qualifier("LIQUIBASE")
    private AbstractConfigCommand liquibaseGenConfigFile;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        final Resolver resolver = pathResolverFactory.build(parameters);
        tokenReplacement.setResolver(resolver);

        Environment env = Environment.valueOf(parameters.get(ENV.name()).toUpperCase());
        yamlGenConfigFile.setEnv(env);

        Stack<Command> commands = new Stack<>();
        commands.push(yamlGenConfigFile);
        commands.push(liquibaseGenConfigFile);
        return new CommandInvoker(commands, logger);
    }
}
