package io.github.devsecops.engine.mojos.sonar;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.domain.resolver.path.PathResolverBuilder;
import io.github.devsecops.engine.domain.resolver.strategy.Resolver;
import io.github.devsecops.engine.domain.sonar.commands.SonarAnalysisCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Stack;

@Service
public class SonarAnalysisFactory implements Factory<Invoker> {

    @Autowired
    private Log logger;

    @Autowired
    private PathResolverBuilder pathResolverFactory;

    @Autowired
    private SonarAnalysisCommand sonarAnalysisCommand;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        final Resolver resolver = pathResolverFactory.build(parameters);
        sonarAnalysisCommand.setResolver(resolver);
        Stack<Command> commands = new Stack<>();
        commands.push(sonarAnalysisCommand);
        return new CommandInvoker(commands, logger);
    }
}