package io.github.devsecops.engine.mojos.validators.pom;

import io.github.devsecops.engine.core.CommandInvoker;
import io.github.devsecops.engine.core.Log;
import io.github.devsecops.engine.core.contract.Command;
import io.github.devsecops.engine.core.contract.Factory;
import io.github.devsecops.engine.core.contract.Invoker;
import io.github.devsecops.engine.domain.pom.commands.PomValidatorCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Stack;

@Service
public class PomValidatorFactory implements Factory<Invoker> {

    @Autowired
    private Log logger;

    @Autowired
    private PomValidatorCommand validatorCommand;

    @Override
    public Invoker build(Map<String, String> parameters) throws Exception {
        Stack<Command> commands = new Stack<>();
        commands.push(validatorCommand);
        return new CommandInvoker(commands, logger);
    }
}
