/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im;

import io.github.doocs.im.util.VersionInfoUtil;

public class ClientConfiguration {
    public static final String DEFAULT_USER_AGENT = VersionInfoUtil.getDefaultUserAgent();
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final boolean DEFAULT_RENEW_SIG = true;
    public static final long DEFAULT_CONNECT_TIMEOUT = 3000L;
    public static final long DEFAULT_READ_TIMEOUT = 3000L;
    public static final long DEFAULT_WRITE_TIMEOUT = 3000L;
    public static final long DEFAULT_EXPIRE_TIME = 86400L;
    private int maxRetries = 3;
    private long connectTimeout = 3000L;
    private long readTimeout = 3000L;
    private long writeTimeout = 3000L;
    private long expireTime = 86400L;
    private boolean autoRenewSig = true;
    private String userAgent = DEFAULT_USER_AGENT;

    public ClientConfiguration() {
    }

    public ClientConfiguration(int maxRetries, long connectTimeout, long readTimeout, long writeTimeout, long expireTime, boolean autoRenewSig, String userAgent) {
        this.maxRetries = maxRetries;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.expireTime = expireTime;
        this.autoRenewSig = autoRenewSig;
        this.userAgent = userAgent;
    }

    private ClientConfiguration(Builder builder) {
        this.maxRetries = builder.maxRetries;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.expireTime = builder.expireTime;
        this.autoRenewSig = builder.autoRenewSig;
        this.userAgent = builder.userAgent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public boolean isAutoRenewSig() {
        return this.autoRenewSig;
    }

    public void setAutoRenewSig(boolean autoRenewSig) {
        this.autoRenewSig = autoRenewSig;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static final class Builder {
        private int maxRetries = 3;
        private long connectTimeout = 3000L;
        private long readTimeout = 3000L;
        private long writeTimeout = 3000L;
        private long expireTime = 86400L;
        private boolean autoRenewSig = true;
        private String userAgent = DEFAULT_USER_AGENT;

        private Builder() {
        }

        public ClientConfiguration build() {
            return new ClientConfiguration(this);
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder writeTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder expireTime(long expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public Builder autoRenewSig(boolean autoRenewSig) {
            this.autoRenewSig = autoRenewSig;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }
    }
}

