/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im;

import io.github.doocs.im.ClientConfiguration;
import io.github.doocs.im.core.Account;
import io.github.doocs.im.core.Group;
import io.github.doocs.im.core.Member;
import io.github.doocs.im.core.Message;
import io.github.doocs.im.core.Operation;
import io.github.doocs.im.core.Profile;
import io.github.doocs.im.core.RecentContact;
import io.github.doocs.im.core.Sns;
import io.github.doocs.im.util.SigUtil;
import java.util.concurrent.ThreadLocalRandom;

public class ImClient {
    private final long sdkAppId;
    private final String key;
    private final String userId;
    private final String domain;
    private final ClientConfiguration config;
    private final long expireTime;
    private String userSig;
    private long userSigExpireTs;
    private static final String VERSION = "v4";
    private static final String DEFAULT_DOMAIN = "console.tim.qq.com";
    private static final String FORMAT_URL = "https://%s/%s/%s/%s?sdkappid=%d&identifier=%s&usersig=%s&random=%d&contenttype=json";
    public final Account account;
    public final Message message;
    public final Member member;
    public final Profile profile;
    public final Group group;
    public final Sns sns;
    public final Operation operation;
    public final RecentContact recentContact;

    public static ImClient getInstance(long sdkAppId, String userId, String key) {
        return new ImClient(sdkAppId, userId, key);
    }

    public static ImClient getInstance(long sdkAppId, String userId, String key, String domain) {
        return new ImClient(sdkAppId, userId, key, domain);
    }

    public static ImClient getInstance(long sdkAppId, String userId, String key, ClientConfiguration config) {
        return new ImClient(sdkAppId, userId, key, config);
    }

    public static ImClient getInstance(long sdkAppId, String userId, String key, String domain, ClientConfiguration config) {
        return new ImClient(sdkAppId, userId, key, domain, config);
    }

    public ImClient(long sdkAppId, String userId, String key) {
        this(sdkAppId, userId, key, DEFAULT_DOMAIN);
    }

    public ImClient(long sdkAppId, String userId, String key, String domain) {
        this(sdkAppId, userId, key, domain, null);
    }

    public ImClient(long sdkAppId, String userId, String key, ClientConfiguration config) {
        this(sdkAppId, userId, key, DEFAULT_DOMAIN, config);
    }

    public ImClient(long sdkAppId, String userId, String key, String domain, ClientConfiguration config) {
        this.sdkAppId = sdkAppId;
        this.userId = userId;
        this.key = key;
        this.domain = domain;
        this.config = config;
        this.expireTime = config == null ? 86400L : config.getExpireTime();
        this.userSig = SigUtil.genUserSig(sdkAppId, key, userId, this.expireTime);
        this.userSigExpireTs = System.currentTimeMillis() / 1000L + this.expireTime - 100L;
        this.account = new Account(this);
        this.message = new Message(this);
        this.member = new Member(this);
        this.profile = new Profile(this);
        this.group = new Group(this);
        this.operation = new Operation(this);
        this.sns = new Sns(this);
        this.recentContact = new RecentContact(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserSig() {
        long currentTs;
        boolean renewSig;
        boolean bl = renewSig = this.config == null || this.config.isAutoRenewSig();
        if (renewSig && (currentTs = System.currentTimeMillis() / 1000L) >= this.userSigExpireTs) {
            ImClient imClient = this;
            synchronized (imClient) {
                if (currentTs >= this.userSigExpireTs) {
                    this.userSig = SigUtil.genUserSig(this.sdkAppId, this.key, this.userId, this.expireTime);
                    this.userSigExpireTs = currentTs + this.expireTime - 100L;
                }
            }
        }
        return this.userSig;
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    public String getUrl(String serviceName, String command) {
        String sig = this.getUserSig();
        long random = ThreadLocalRandom.current().nextLong(0L, 0x100000000L);
        return String.format(FORMAT_URL, this.domain, VERSION, serviceName, command, this.sdkAppId, this.userId, sig, random);
    }
}

