/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.core;

import io.github.doocs.im.ImClient;
import io.github.doocs.im.model.request.AccountCheckRequest;
import io.github.doocs.im.model.request.AccountDeleteRequest;
import io.github.doocs.im.model.request.AccountImportRequest;
import io.github.doocs.im.model.request.KickRequest;
import io.github.doocs.im.model.request.MultiAccountImportRequest;
import io.github.doocs.im.model.request.QueryOnlineStatusRequest;
import io.github.doocs.im.model.response.AccountCheckResult;
import io.github.doocs.im.model.response.AccountDeleteResult;
import io.github.doocs.im.model.response.AccountImportResult;
import io.github.doocs.im.model.response.KickResult;
import io.github.doocs.im.model.response.MultiAccountImportResult;
import io.github.doocs.im.model.response.QueryOnlineStatusResult;
import io.github.doocs.im.util.HttpUtil;
import java.io.IOException;

public class Account {
    private static final String SERVICE_NAME = "im_open_login_svc";
    private static final String SERVICE_NAME_OPEN_IM = "openim";
    private static final String ACCOUNT_IMPORT_COMMAND = "account_import";
    private static final String MULTI_ACCOUNT_IMPORT_COMMAND = "multiaccount_import";
    private static final String ACCOUNT_DELETE_COMMAND = "account_delete";
    private static final String ACCOUNT_CHECK_COMMAND = "account_check";
    private static final String KICK_COMMAND = "kick";
    private static final String QUERY_ONLINE_STATUS_COMMAND = "query_online_status";
    private final ImClient imClient;

    public Account(ImClient imClient) {
        this.imClient = imClient;
    }

    public AccountImportResult accountImport(AccountImportRequest accountImportRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ACCOUNT_IMPORT_COMMAND);
        return HttpUtil.post(url, accountImportRequest, AccountImportResult.class, this.imClient.getConfig());
    }

    public MultiAccountImportResult multiAccountImport(MultiAccountImportRequest multiAccountImportRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, MULTI_ACCOUNT_IMPORT_COMMAND);
        return HttpUtil.post(url, multiAccountImportRequest, MultiAccountImportResult.class, this.imClient.getConfig());
    }

    public AccountDeleteResult accountDelete(AccountDeleteRequest accountDeleteRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ACCOUNT_DELETE_COMMAND);
        return HttpUtil.post(url, accountDeleteRequest, AccountDeleteResult.class, this.imClient.getConfig());
    }

    public AccountCheckResult accountCheck(AccountCheckRequest accountCheckRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ACCOUNT_CHECK_COMMAND);
        return HttpUtil.post(url, accountCheckRequest, AccountCheckResult.class, this.imClient.getConfig());
    }

    public KickResult kick(KickRequest kickRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, KICK_COMMAND);
        return HttpUtil.post(url, kickRequest, KickResult.class, this.imClient.getConfig());
    }

    public QueryOnlineStatusResult queryOnlineStatus(QueryOnlineStatusRequest queryOnlineStatusRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME_OPEN_IM, QUERY_ONLINE_STATUS_COMMAND);
        return HttpUtil.post(url, queryOnlineStatusRequest, QueryOnlineStatusResult.class, this.imClient.getConfig());
    }
}

