/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.core;

import io.github.doocs.im.ImClient;
import io.github.doocs.im.model.request.ImAddTagRequest;
import io.github.doocs.im.model.request.ImGetAttrNameRequest;
import io.github.doocs.im.model.request.ImGetAttrRequest;
import io.github.doocs.im.model.request.ImGetTagRequest;
import io.github.doocs.im.model.request.ImPushRequest;
import io.github.doocs.im.model.request.ImRemoveAllTagsRequest;
import io.github.doocs.im.model.request.ImRemoveAttrRequest;
import io.github.doocs.im.model.request.ImRemoveTagRequest;
import io.github.doocs.im.model.request.ImSetAttrNameRequest;
import io.github.doocs.im.model.request.ImSetAttrRequest;
import io.github.doocs.im.model.response.ImAddTagResult;
import io.github.doocs.im.model.response.ImGetAttrNameResult;
import io.github.doocs.im.model.response.ImGetAttrResult;
import io.github.doocs.im.model.response.ImGetTagResult;
import io.github.doocs.im.model.response.ImPushResult;
import io.github.doocs.im.model.response.ImRemoveAllTagsResult;
import io.github.doocs.im.model.response.ImRemoveAttrResult;
import io.github.doocs.im.model.response.ImRemoveTagResult;
import io.github.doocs.im.model.response.ImSetAttrNameResult;
import io.github.doocs.im.model.response.ImSetAttrResult;
import io.github.doocs.im.util.HttpUtil;
import java.io.IOException;

public class Member {
    private static final String SERVICE_NAME = "all_member_push";
    private static final String IM_PUSH_COMMAND = "im_push";
    private static final String IM_SET_ATTR_NAME_COMMAND = "im_set_attr_name";
    private static final String IM_GET_ATTR_NAME_COMMAND = "im_get_attr_name";
    private static final String IM_GET_ATTR_COMMAND = "im_get_attr";
    private static final String IM_SET_ATTR_COMMAND = "im_set_attr";
    private static final String IM_REMOVE_ATTR_COMMAND = "im_remove_attr";
    private static final String IM_GET_TAG_COMMAND = "im_get_tag";
    private static final String IM_ADD_TAG_COMMAND = "im_add_tag";
    private static final String IM_REMOVE_TAG_COMMAND = "im_remove_tag";
    private static final String IM_REMOVE_ALL_TAGS_COMMAND = "im_remove_all_tags";
    private final ImClient imClient;

    public Member(ImClient imClient) {
        this.imClient = imClient;
    }

    public ImPushResult imPush(ImPushRequest imPushRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_PUSH_COMMAND);
        return HttpUtil.post(url, imPushRequest, ImPushResult.class, this.imClient.getConfig());
    }

    public ImSetAttrNameResult imSetAttrName(ImSetAttrNameRequest imSetAttrNameRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_SET_ATTR_NAME_COMMAND);
        return HttpUtil.post(url, imSetAttrNameRequest, ImSetAttrNameResult.class, this.imClient.getConfig());
    }

    public ImGetAttrNameResult imGetAttrName(ImGetAttrNameRequest imGetAttrNameRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_GET_ATTR_NAME_COMMAND);
        return HttpUtil.post(url, imGetAttrNameRequest, ImGetAttrNameResult.class, this.imClient.getConfig());
    }

    public ImGetAttrResult imGetAttr(ImGetAttrRequest imGetAttrRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_GET_ATTR_COMMAND);
        return HttpUtil.post(url, imGetAttrRequest, ImGetAttrResult.class, this.imClient.getConfig());
    }

    public ImSetAttrResult imSetAttr(ImSetAttrRequest imSetAttrRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_SET_ATTR_COMMAND);
        return HttpUtil.post(url, imSetAttrRequest, ImSetAttrResult.class, this.imClient.getConfig());
    }

    public ImRemoveAttrResult imRemoveAttr(ImRemoveAttrRequest imRemoveAttrRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_REMOVE_ATTR_COMMAND);
        return HttpUtil.post(url, imRemoveAttrRequest, ImRemoveAttrResult.class, this.imClient.getConfig());
    }

    public ImGetTagResult imGetTag(ImGetTagRequest imGetTagRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_GET_TAG_COMMAND);
        return HttpUtil.post(url, imGetTagRequest, ImGetTagResult.class, this.imClient.getConfig());
    }

    public ImAddTagResult imAddTag(ImAddTagRequest imAddTagRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_ADD_TAG_COMMAND);
        return HttpUtil.post(url, imAddTagRequest, ImAddTagResult.class, this.imClient.getConfig());
    }

    public ImRemoveTagResult imRemoveTag(ImRemoveTagRequest imRemoveTagRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_REMOVE_TAG_COMMAND);
        return HttpUtil.post(url, imRemoveTagRequest, ImRemoveTagResult.class, this.imClient.getConfig());
    }

    public ImRemoveAllTagsResult imRemoveAllTags(ImRemoveAllTagsRequest imRemoveAllTagsRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IM_REMOVE_ALL_TAGS_COMMAND);
        return HttpUtil.post(url, imRemoveAllTagsRequest, ImRemoveAllTagsResult.class, this.imClient.getConfig());
    }
}

