/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.core;

import io.github.doocs.im.ImClient;
import io.github.doocs.im.model.request.AdminGetRoamMsgRequest;
import io.github.doocs.im.model.request.AdminMsgWithdrawRequest;
import io.github.doocs.im.model.request.AdminSetMsgReadRequest;
import io.github.doocs.im.model.request.BatchSendMsgRequest;
import io.github.doocs.im.model.request.GetC2cUnreadMsgRequest;
import io.github.doocs.im.model.request.ImportMsgRequest;
import io.github.doocs.im.model.request.SendMsgRequest;
import io.github.doocs.im.model.response.AdminMsgWithdrawResult;
import io.github.doocs.im.model.response.AdminRoamMsgResult;
import io.github.doocs.im.model.response.AdminSetMsgReadResult;
import io.github.doocs.im.model.response.BatchSendMsgResult;
import io.github.doocs.im.model.response.C2cUnreadMsgNumResult;
import io.github.doocs.im.model.response.ImportMsgResult;
import io.github.doocs.im.model.response.SendMsgResult;
import io.github.doocs.im.util.HttpUtil;
import java.io.IOException;

public class Message {
    private static final String SERVICE_NAME = "openim";
    private static final String SEND_MSG_COMMAND = "sendmsg";
    private static final String IMPORT_MSG_COMMAND = "importmsg";
    private static final String BATCH_SEND_MSG_COMMAND = "batchsendmsg";
    private static final String ADMIN_GET_ROAM_MSG_COMMAND = "admin_getroammsg";
    private static final String ADMIN_MSG_WITHDRAW_COMMAND = "admin_msgwithdraw";
    private static final String ADMIN_SET_MSG_READ_COMMAND = "admin_set_msg_read";
    private static final String GET_C2C_UNREAD_MSG_NUM_COMMAND = "get_c2c_unread_msg_num";
    private final ImClient imClient;

    public Message(ImClient imClient) {
        this.imClient = imClient;
    }

    public SendMsgResult sendMsg(SendMsgRequest sendMsgRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, SEND_MSG_COMMAND);
        return HttpUtil.post(url, sendMsgRequest, SendMsgResult.class, this.imClient.getConfig());
    }

    public BatchSendMsgResult batchSendMsg(BatchSendMsgRequest batchSendMsgRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, BATCH_SEND_MSG_COMMAND);
        return HttpUtil.post(url, batchSendMsgRequest, BatchSendMsgResult.class, this.imClient.getConfig());
    }

    public ImportMsgResult importMsg(ImportMsgRequest importMsgRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, IMPORT_MSG_COMMAND);
        return HttpUtil.post(url, importMsgRequest, ImportMsgResult.class, this.imClient.getConfig());
    }

    public AdminRoamMsgResult getRoamMsg(AdminGetRoamMsgRequest adminGetRoamMsgRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ADMIN_GET_ROAM_MSG_COMMAND);
        return HttpUtil.post(url, adminGetRoamMsgRequest, AdminRoamMsgResult.class, this.imClient.getConfig());
    }

    public AdminMsgWithdrawResult msgWithdraw(AdminMsgWithdrawRequest adminMsgWithdrawRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ADMIN_MSG_WITHDRAW_COMMAND);
        return HttpUtil.post(url, adminMsgWithdrawRequest, AdminMsgWithdrawResult.class, this.imClient.getConfig());
    }

    public AdminSetMsgReadResult setMsgRead(AdminSetMsgReadRequest adminSetMsgReadRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, ADMIN_SET_MSG_READ_COMMAND);
        return HttpUtil.post(url, adminSetMsgReadRequest, AdminSetMsgReadResult.class, this.imClient.getConfig());
    }

    public C2cUnreadMsgNumResult getC2cUnreadMsgNum(GetC2cUnreadMsgRequest getC2cUnreadMsgRequest) throws IOException {
        String url = this.imClient.getUrl(SERVICE_NAME, GET_C2C_UNREAD_MSG_NUM_COMMAND);
        return HttpUtil.post(url, getC2cUnreadMsgRequest, C2cUnreadMsgNumResult.class, this.imClient.getConfig());
    }
}

