/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.util;

import io.github.doocs.im.ClientConfiguration;
import io.github.doocs.im.util.JsonUtil;
import io.github.doocs.im.util.RetryInterceptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtil {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final ClientConfiguration DEFAULT_CONFIG = new ClientConfiguration();
    private static final String DEFAULT_USER_AGENT = DEFAULT_CONFIG.getUserAgent();
    private static final OkHttpClient DEFAULT_CLIENT = new OkHttpClient.Builder().connectTimeout(DEFAULT_CONFIG.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(DEFAULT_CONFIG.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(DEFAULT_CONFIG.getWriteTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(false).addInterceptor((Interceptor)new RetryInterceptor(DEFAULT_CONFIG.getMaxRetries())).build();

    private HttpUtil() {
    }

    public static String post(String url, String json, ClientConfiguration config) throws IOException {
        OkHttpClient httpClient = DEFAULT_CLIENT;
        if (config != null) {
            httpClient = new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(config.getWriteTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(false).addInterceptor((Interceptor)new RetryInterceptor(config.getMaxRetries())).build();
        }
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put(USER_AGENT_KEY, config == null || config.getUserAgent() == null ? DEFAULT_USER_AGENT : config.getUserAgent());
        return HttpUtil.post(url, json, httpClient, headers);
    }

    public static String post(String url, String json, OkHttpClient httpClient, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
        Headers.Builder hb = new Headers.Builder();
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Headers.Builder)hb).add(arg_0, arg_1));
        }
        Request request = new Request.Builder().url(url).headers(hb.build()).post(body).build();
        try (Response response = httpClient.newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    public static <T> T post(String url, Object data, Class<T> cls, ClientConfiguration config) throws IOException {
        String result = HttpUtil.post(url, JsonUtil.obj2Str(data), config);
        return JsonUtil.str2Obj(result, cls);
    }

    public static <T> T post(String url, Object data, Class<T> cls) throws IOException {
        return HttpUtil.post(url, data, cls, null);
    }

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = DEFAULT_CLIENT.newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }
}

