/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.util;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class RetryInterceptor
implements Interceptor {
    private int maxRetry;

    RetryInterceptor(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        for (int i = 0; i < this.maxRetry && !response.isSuccessful(); ++i) {
            response.close();
            response = chain.proceed(request);
        }
        return response;
    }
}

