/*
 * Decompiled with CFR 0.152.
 */
package io.github.doocs.im.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.doocs.im.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.zip.Deflater;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SigUtil {
    private SigUtil() {
    }

    public static String genUserSig(long sdkAppId, String key, String userId, long expire) {
        return SigUtil.genUserSig(sdkAppId, key, userId, expire, null);
    }

    public static String genPrivateMapKey(long sdkAppId, String key, String userId, long expire, long roomId, long privilegeMap) {
        byte[] userBuf = SigUtil.genUserBuf(sdkAppId, userId, roomId, expire, privilegeMap, 0L, "");
        return SigUtil.genUserSig(sdkAppId, key, userId, expire, userBuf);
    }

    public static String genPrivateMapKeyWithStringRoomId(long sdkAppId, String key, String userId, long expire, String roomStr, long privilegeMap) {
        byte[] userBuf = SigUtil.genUserBuf(sdkAppId, userId, 0L, expire, privilegeMap, 0L, roomStr);
        return SigUtil.genUserSig(sdkAppId, key, userId, expire, userBuf);
    }

    private static String hmacSHA256(long sdkAppId, String key, String identifier, long currTime, long expire, String base64UserBuf) {
        String contentToBeSigned = "TLS.identifier:" + identifier + "\nTLS.sdkappid:" + sdkAppId + "\nTLS.time:" + currTime + "\nTLS.expire:" + expire + "\n";
        if (null != base64UserBuf) {
            contentToBeSigned = contentToBeSigned + "TLS.userbuf:" + base64UserBuf + "\n";
        }
        try {
            byte[] byteKey = key.getBytes(StandardCharsets.UTF_8);
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keySpec = new SecretKeySpec(byteKey, "HmacSHA256");
            hmac.init(keySpec);
            byte[] byteSig = hmac.doFinal(contentToBeSigned.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(byteSig).replaceAll("\\s*", "");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    private static String genUserSig(long sdkAppId, String key, String userId, long expire, byte[] userBuf) {
        String sig;
        long currTime = System.currentTimeMillis() / 1000L;
        HashMap<String, Object> sigDoc = new HashMap<String, Object>(8);
        sigDoc.put("TLS.ver", "2.0");
        sigDoc.put("TLS.identifier", userId);
        sigDoc.put("TLS.sdkappid", sdkAppId);
        sigDoc.put("TLS.expire", expire);
        sigDoc.put("TLS.time", currTime);
        String base64UserBuf = null;
        if (null != userBuf) {
            base64UserBuf = Base64.getEncoder().encodeToString(userBuf).replaceAll("\\s*", "");
            sigDoc.put("TLS.userbuf", base64UserBuf);
        }
        if ((sig = SigUtil.hmacSHA256(sdkAppId, key, userId, currTime, expire, base64UserBuf)).length() == 0) {
            return "";
        }
        sigDoc.put("TLS.sig", sig);
        Deflater compressor = new Deflater();
        try {
            compressor.setInput(JsonUtil.obj2Str(sigDoc).getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            compressor.setInput(new byte[0]);
        }
        compressor.finish();
        byte[] compressedBytes = new byte[2048];
        int compressedBytesLength = compressor.deflate(compressedBytes);
        compressor.end();
        return new String(SigUtil.base64EncodeUrl(Arrays.copyOfRange(compressedBytes, 0, compressedBytesLength))).replaceAll("\\s*", "");
    }

    private static byte[] genUserBuf(long sdkAppId, String account, long dwAuthID, long dwExpTime, long dwPrivilegeMap, long dwAccountType, String roomStr) {
        int accountLength = account.length();
        int roomStrLength = roomStr.length();
        int offset = 0;
        int bufLength = 3 + accountLength + 20;
        if (roomStrLength > 0) {
            bufLength = bufLength + 2 + roomStrLength;
        }
        byte[] userBuf = new byte[bufLength];
        userBuf[offset++] = roomStrLength > 0 ? (byte)1 : 0;
        userBuf[offset++] = (byte)((accountLength & 0xFF00) >> 8);
        userBuf[offset++] = (byte)(accountLength & 0xFF);
        while (offset < 3 + accountLength) {
            userBuf[offset] = (byte)account.charAt(offset - 3);
            ++offset;
        }
        userBuf[offset++] = (byte)((sdkAppId & 0xFFFFFFFFFF000000L) >> 24);
        userBuf[offset++] = (byte)((sdkAppId & 0xFF0000L) >> 16);
        userBuf[offset++] = (byte)((sdkAppId & 0xFF00L) >> 8);
        userBuf[offset++] = (byte)(sdkAppId & 0xFFL);
        userBuf[offset++] = (byte)((dwAuthID & 0xFFFFFFFFFF000000L) >> 24);
        userBuf[offset++] = (byte)((dwAuthID & 0xFF0000L) >> 16);
        userBuf[offset++] = (byte)((dwAuthID & 0xFF00L) >> 8);
        userBuf[offset++] = (byte)(dwAuthID & 0xFFL);
        long currTime = System.currentTimeMillis() / 1000L;
        long expire = currTime + dwExpTime;
        userBuf[offset++] = (byte)((expire & 0xFFFFFFFFFF000000L) >> 24);
        userBuf[offset++] = (byte)((expire & 0xFF0000L) >> 16);
        userBuf[offset++] = (byte)((expire & 0xFF00L) >> 8);
        userBuf[offset++] = (byte)(expire & 0xFFL);
        userBuf[offset++] = (byte)((dwPrivilegeMap & 0xFFFFFFFFFF000000L) >> 24);
        userBuf[offset++] = (byte)((dwPrivilegeMap & 0xFF0000L) >> 16);
        userBuf[offset++] = (byte)((dwPrivilegeMap & 0xFF00L) >> 8);
        userBuf[offset++] = (byte)(dwPrivilegeMap & 0xFFL);
        userBuf[offset++] = (byte)((dwAccountType & 0xFFFFFFFFFF000000L) >> 24);
        userBuf[offset++] = (byte)((dwAccountType & 0xFF0000L) >> 16);
        userBuf[offset++] = (byte)((dwAccountType & 0xFF00L) >> 8);
        userBuf[offset++] = (byte)(dwAccountType & 0xFFL);
        if (roomStrLength > 0) {
            userBuf[offset++] = (byte)((roomStrLength & 0xFF00) >> 8);
            userBuf[offset++] = (byte)(roomStrLength & 0xFF);
            while (offset < bufLength) {
                userBuf[offset] = (byte)roomStr.charAt(offset - (bufLength - roomStrLength));
                ++offset;
            }
        }
        return userBuf;
    }

    private static byte[] base64EncodeUrl(byte[] input) {
        byte[] base64 = Base64.getEncoder().encode(input);
        block5: for (int i = 0; i < base64.length; ++i) {
            switch (base64[i]) {
                case 43: {
                    base64[i] = 42;
                    continue block5;
                }
                case 47: {
                    base64[i] = 45;
                    continue block5;
                }
                case 61: {
                    base64[i] = 95;
                    continue block5;
                }
            }
        }
        return base64;
    }
}

