/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import com.google.common.base.CaseFormat;
import generic.annotation.IgnoreToPutJsonResponse;
import java.lang.reflect.Field;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ParasutUtil {
    public static DateTimeFormatter parasutDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static Map<Object, Object> populateAttributesWithObjectFields(Object o, Boolean convertCamelToUnderScore) {
        Class<?> clazz = o.getClass();
        HashMap<Object, Object> attributes = new HashMap<Object, Object>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(IgnoreToPutJsonResponse.class)) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(o);
                if (!Objects.nonNull(obj)) continue;
                String key = field.getName();
                if (convertCamelToUnderScore.booleanValue()) {
                    key = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, key);
                }
                attributes.put(key, obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return attributes;
    }
}

