/*
 * Decompiled with CFR 0.152.
 */
package http;

import com.google.gson.Gson;
import exception.ParasutHttpClientException;
import http.enums.HttpMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.CodingErrorAction;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParasutHttpClient {
    private static final Logger log = LoggerFactory.getLogger(ParasutHttpClient.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private static final int TIMEOUT = 140000;
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_PROPERTY = "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0";
    Map<String, String> headers;
    Object request;
    String url;
    CloseableHttpClient httpClient;
    HttpPost httpPost;
    HttpGet httpGet;
    RequestConfig requestConfig;
    private CloseableHttpResponse closeableHttpResponse;
    private BufferedReader bufferedReader;

    public ParasutHttpClient() {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        connManager.setDefaultSocketConfig(socketConfig);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(140000).setConnectTimeout(140000).setConnectionRequestTimeout(140000).build();
    }

    public <T> T get(Class<T> responseType) {
        try {
            this.httpGet = new HttpGet(this.url);
            this.httpGet.setConfig(this.requestConfig);
            Gson gson = new Gson();
            String response = this.send(HttpMethod.GET, null, (HttpRequestBase)this.httpGet);
            return (T)gson.fromJson(response, responseType);
        }
        catch (IOException e) {
            throw new ParasutHttpClientException(e.getMessage(), e);
        }
    }

    public <T> T post(Class<T> responseType) {
        this.httpPost = new HttpPost();
        this.httpPost.setURI(URI.create(this.url));
        try {
            Gson gson = new Gson();
            String body = gson.toJson(this.request);
            StringEntity entity = new StringEntity(body);
            this.httpPost.setEntity((HttpEntity)entity);
            String response = this.send(HttpMethod.POST, entity, (HttpRequestBase)this.httpPost);
            return (T)gson.fromJson(response, responseType);
        }
        catch (IOException e) {
            throw new ParasutHttpClientException(e.getMessage(), e);
        }
    }

    private String send(HttpMethod httpMethod, StringEntity entity, HttpRequestBase requestBase) throws IOException {
        if (Objects.nonNull(entity) && HttpMethod.POST.equals((Object)httpMethod)) {
            this.httpPost.setEntity((HttpEntity)entity);
        }
        this.prepareHeaders(requestBase);
        return this.getResponse(requestBase);
    }

    private void prepareHeaders(HttpRequestBase requestBase) {
        requestBase.setHeader(CONTENT_TYPE, APPLICATION_JSON);
        requestBase.setHeader(ACCEPT, APPLICATION_JSON);
        requestBase.setHeader(USER_AGENT, USER_AGENT_PROPERTY);
        if (Objects.nonNull(this.headers)) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                requestBase.setHeader(header.getKey(), header.getValue());
            }
        }
    }

    private String getResponse(HttpRequestBase requestBase) {
        try {
            this.closeableHttpResponse = this.httpClient.execute((HttpUriRequest)requestBase);
            String string = this.getContent();
            return string;
        }
        catch (IOException e) {
            throw new ParasutHttpClientException(e.getMessage(), e);
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)this.closeableHttpResponse.getEntity());
                this.after(requestBase);
            }
            catch (IOException e) {
                throw new ParasutHttpClientException(e.getMessage(), e);
            }
        }
    }

    private String getContent() throws IOException {
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.closeableHttpResponse.getEntity().getContent()));
        String body = "";
        StringBuilder content = new StringBuilder();
        while ((body = this.bufferedReader.readLine()) != null) {
            content.append(body).append("\n");
        }
        return content.toString().trim();
    }

    public final void after(HttpRequestBase requestBase) throws IllegalStateException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("closing http client connection...");
        }
        requestBase.completed();
        this.httpClient.close();
        if (Objects.nonNull(this.bufferedReader)) {
            this.bufferedReader.close();
        }
        ParasutHttpClient.closeResponse(this.closeableHttpResponse);
    }

    public static void closeResponse(CloseableHttpResponse response) throws IOException {
        if (response == null) {
            return;
        }
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                entity.getContent().close();
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("closed http client connection...");
            }
            response.close();
        }
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }

    public static class ClientBuilder {
        private Map<String, String> headers;
        private Object request;
        private String url;

        public ClientBuilder addUrl(String url) {
            this.url = url;
            return this;
        }

        public ClientBuilder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ClientBuilder withData(Object request) {
            this.request = request;
            return this;
        }

        public ParasutHttpClient build() {
            ParasutHttpClient client = new ParasutHttpClient();
            client.headers = this.headers;
            client.url = this.url;
            client.request = this.request;
            return client;
        }
    }
}

