/*
 * Decompiled with CFR 0.152.
 */
package model.invoice;

import generic.enums.ParasutObjectType;
import generic.util.ParasutUtil;
import http.HttpOptions;
import http.ParasutHttpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import model.invoice.ParasutInvoiceDetails;
import model.invoice.ParasutInvoiceRequest;
import model.request.ParasutGenericRequest;
import model.request.ParasutRequest;
import model.request.ParasutSimpleDataRequest;
import model.request.ParasutSimpleRequest;

public class ParasutInvoice
extends ParasutGenericRequest {
    public static ParasutInvoice create(HttpOptions httpOptions, ParasutInvoiceRequest invoiceRequest, ParasutSimpleRequest simpleRequest) {
        String url = httpOptions.getBaseUrl() + httpOptions.getApiVersion() + "/" + simpleRequest.getCompanyId() + "/" + ParasutObjectType.SALES_INVOICES.getValue();
        return ParasutHttpClient.builder().addUrl(url).withHeaders(ParasutInvoice.getHttpHeaders(simpleRequest)).withData(ParasutGenericRequest.builder().data(ParasutRequest.builder().type(ParasutObjectType.SALES_INVOICES.getValue()).attributes(ParasutUtil.populateAttributesWithObjectFields(invoiceRequest.attributes, true)).relationships(ParasutInvoice.getInvoiceRelation(invoiceRequest)).build())).build().post(ParasutInvoice.class);
    }

    private static Map<Object, Object> getInvoiceRelation(ParasutInvoiceRequest invoiceRequest) {
        HashMap<Object, Object> relationship = new HashMap<Object, Object>();
        relationship.put("contact", ParasutSimpleDataRequest.builder().data(ParasutRequest.builder().id(invoiceRequest.getContactId()).type(ParasutObjectType.CONTACTS.getValue()).build()).build());
        ArrayList tagList = new ArrayList();
        if (Objects.nonNull(invoiceRequest.getTagList())) {
            invoiceRequest.getTagList().forEach(s -> tagList.add(ParasutRequest.builder().id((String)s).type(ParasutObjectType.TAGS.getValue()).build()));
            relationship.put("tags", ParasutSimpleDataRequest.builder().data(tagList).build());
        }
        if (Objects.nonNull(invoiceRequest.getCategoryId())) {
            relationship.put("category", ParasutSimpleDataRequest.builder().data(ParasutRequest.builder().id(invoiceRequest.getCategoryId()).type(ParasutObjectType.ITEM_CATEGORIES.getValue()).build()).build());
        }
        ArrayList<ParasutRequest> parasutRequestList = new ArrayList<ParasutRequest>();
        for (final ParasutInvoiceDetails detail : invoiceRequest.getDetails()) {
            parasutRequestList.add(ParasutRequest.builder().type(ParasutObjectType.SALES_INVOICE_DETAILS.getValue()).attributes(ParasutUtil.populateAttributesWithObjectFields(detail, true)).relationships((Map<Object, Object>)new HashMap<Object, Object>(){
                {
                    this.put("product", ParasutSimpleDataRequest.builder().data(ParasutRequest.builder().type(ParasutObjectType.PRODUCTS.getValue()).id(detail.getProductId()).build()).build());
                }
            }).build());
        }
        relationship.put("details", ParasutSimpleDataRequest.builder().data(parasutRequestList).build());
        return relationship;
    }
}

