/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.javafx.javascript.editor.attribute.visualisation;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.CodeHighlightingAssistant;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.ContentAssistant;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.ErrorsAndWarningsAssistant;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.Proposal;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.Span;
import io.github.factoryfx.javascript.data.attributes.types.Javascript;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.StyleSpansBuilder;
import org.fxmisc.richtext.StyledTextArea;

public class JavascriptVisual<A> {
    private final List<SourceFile> externs;

    public JavascriptVisual(List<SourceFile> externs) {
        this.externs = externs;
    }

    public Node createContent(SimpleObjectProperty<Javascript<A>> boundTo) {
        return new RootNode<A>(this.externs, boundTo);
    }

    static class RootNode<A>
    extends StackPane {
        final Consumer<List<JSError>> processErrorsAndWarnings = this::processErrorsAndWarnings;
        final Consumer<NavigableMap<Integer, List<Proposal>>> processProoposals = this::processProposals;
        final Consumer<List<Span>> processHighlighting = this::processHighlighting;
        final ContentAssistant contentAssistant;
        final ErrorsAndWarningsAssistant errorsAndWarningsAssistant;
        final CodeHighlightingAssistant codeHighlightingAssistant = new CodeHighlightingAssistant(new WeakReference<Consumer<List<Span>>>(this.processHighlighting));
        final CodeArea codeArea = new CodeArea();
        final ListView<JSError> errorsAndWarnings = new ListView();
        final ChangeListener<Javascript<A>> onUpdateScript;

        RootNode(List<SourceFile> externs, SimpleObjectProperty<Javascript<A>> boundTo) {
            this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("jsstyle.css").toExternalForm());
            ArrayList<SourceFile> externalSources = new ArrayList<SourceFile>(externs);
            this.contentAssistant = new ContentAssistant(externalSources, new WeakReference<Consumer<NavigableMap<Integer, List<Proposal>>>>(this.processProoposals));
            this.errorsAndWarningsAssistant = new ErrorsAndWarningsAssistant(externalSources, new WeakReference<Consumer<List<JSError>>>(this.processErrorsAndWarnings));
            this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((StyledTextArea)this.codeArea));
            this.onUpdateScript = (observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.getCode().equals(this.codeArea.getText())) {
                    this.codeArea.replaceText(newValue.getCode());
                }
                this.updateAssistants((Javascript)boundTo.get());
            };
            boundTo.addListener((ChangeListener)new WeakChangeListener(this.onUpdateScript));
            this.codeArea.onKeyPressedProperty().set(this::handleKeys);
            this.codeArea.onKeyReleasedProperty().set(this::handleKeys);
            if (boundTo.get() != null) {
                this.codeArea.insertText(0, ((Javascript)boundTo.get()).getCode());
            }
            this.codeArea.textProperty().addListener((a, b, newValue) -> {
                if (boundTo.get() == null || ((Javascript)boundTo.get()).getCode() == null) {
                    boundTo.set((Object)new Javascript(newValue));
                } else if (!((Javascript)boundTo.get()).getCode().equals(newValue)) {
                    boundTo.set((Object)((Javascript)boundTo.get()).copyWithNewCode(newValue));
                }
            });
            this.errorsAndWarnings.setCellFactory(lv -> {
                ListCell cell = new ListCell();
                Function<JSError, String> toText = e -> e.getType().key + ". " + e.description + " at line " + (e.getLineNumber() != -1 ? String.valueOf(e.getLineNumber()) : "(unknown line)") + " : " + (e.getCharno() != -1 ? String.valueOf(e.getCharno() + 1) : "(unknown column)");
                cell.itemProperty().addListener((a, b, newValue) -> {
                    cell.getStyleClass().removeIf(c -> Arrays.stream(CheckLevel.values()).anyMatch(l -> l.name().equals(c)));
                    if (newValue != null) {
                        cell.getStyleClass().add((Object)newValue.getType().level.name());
                        cell.setText(((String)toText.apply((JSError)newValue)).replaceAll("\\s+", " "));
                    } else {
                        cell.setText("");
                    }
                });
                cell.setOnMouseClicked(e -> {
                    this.jumpToError((ListCell<JSError>)cell);
                    Platform.runLater(() -> ((CodeArea)this.codeArea).requestFocus());
                });
                cell.setOnKeyTyped(e -> {
                    if (e.getCode() == KeyCode.ENTER) {
                        this.jumpToError((ListCell<JSError>)cell);
                    } else if (!e.getCode().isNavigationKey()) {
                        Platform.runLater(() -> {
                            this.codeArea.requestFocus();
                            this.codeArea.getOnKeyTyped().handle(e);
                        });
                    }
                });
                return cell;
            });
            this.errorsAndWarnings.getSelectionModel().selectedItemProperty().addListener((a, oldValue, newValue) -> {});
            this.updateAssistants((Javascript)boundTo.get());
            SplitPane area = new SplitPane();
            area.setOrientation(Orientation.VERTICAL);
            area.setDividerPosition(0, 0.8);
            area.getItems().add((Object)this.codeArea);
            area.getItems().add(this.errorsAndWarnings);
            SplitPane.setResizableWithParent((Node)this.codeArea, (Boolean)true);
            this.getChildren().add((Object)area);
            StackPane.setMargin((Node)area, (Insets)Insets.EMPTY);
        }

        private void jumpToError(ListCell<JSError> cell) {
            JSError newValue = (JSError)cell.getItem();
            if (newValue != null) {
                Platform.runLater(() -> this.codeArea.positionCaret(this.codeArea.position(newValue.lineNumber - 1, newValue.getCharno()).toOffset()));
            }
        }

        private void handleKeys(KeyEvent keyEvent) {
        }

        private void updateAssistants(Javascript<?> javascript) {
            if (javascript == null) {
                javascript = new Javascript("");
            }
            this.contentAssistant.accept(javascript);
            this.errorsAndWarningsAssistant.accept(javascript);
            this.codeHighlightingAssistant.accept(javascript);
        }

        private void processHighlighting(List<Span> spans) {
            if (!spans.isEmpty()) {
                spans.sort(Comparator.comparingInt(s2 -> s2.from));
                StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
                int last = 0;
                int textLength = this.codeArea.getText().length();
                for (Span s : spans) {
                    int newFrom = Math.min(s.from, textLength);
                    if (newFrom > last) {
                        spansBuilder.add(Collections.emptyList(), newFrom - last);
                    }
                    spansBuilder.add(Collections.singleton(s.style()), s.len);
                    last = s.from + s.len;
                }
                if (last < textLength) {
                    spansBuilder.add(Collections.emptyList(), textLength - last);
                }
                try {
                    this.codeArea.setStyleSpans(0, spansBuilder.create());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private void processErrorsAndWarnings(List<JSError> jsErrors) {
            if (!jsErrors.isEmpty()) {
                if (!this.errorsAndWarnings.getStyleClass().contains((Object)"error")) {
                    this.errorsAndWarnings.getStyleClass().add((Object)"error");
                }
            } else {
                this.errorsAndWarnings.getStyleClass().removeAll((Object[])new String[]{"error"});
            }
            this.errorsAndWarnings.getItems().setAll(jsErrors);
        }

        private void processProposals(NavigableMap<Integer, List<Proposal>> p) {
        }
    }
}

