/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.javafx.javascript.editor.attribute.visualisation;

import com.google.common.base.Throwables;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import io.github.factoryfx.javafx.javascript.editor.attribute.visualisation.DiscardOutputStream;
import io.github.factoryfx.javascript.data.attributes.types.Javascript;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ErrorsAndWarningsCompiler {
    public List<JSError> createErrorsAndWarnings(List<SourceFile> externalSources, Javascript code) {
        Compiler compiler = new Compiler(new PrintStream((OutputStream)new DiscardOutputStream(), false, StandardCharsets.UTF_8));
        compiler.disableThreads();
        try {
            ArrayList<SourceFile> externals = new ArrayList<SourceFile>(externalSources);
            externals.add(SourceFile.fromCode((String)"declarations", (String)code.getHeaderCode()));
            externals.add(SourceFile.fromCode((String)"apiDecl", (String)code.getDeclarationCode()));
            ArrayList<SourceFile> internalSource = new ArrayList<SourceFile>();
            internalSource.add(SourceFile.fromCode((String)"intern", (String)code.getCode()));
            Result res = compiler.compile(externals, internalSource, ErrorsAndWarningsCompiler.createCompilerOptions());
            ArrayList<JSError> warningsAndErrors = new ArrayList<JSError>();
            Predicate<JSError> isFromIntern = e -> e.node == null || !e.node.isFromExterns() && "intern".equals(e.node.getSourceFileName());
            Stream.of(res.errors).filter(isFromIntern).forEach(warningsAndErrors::add);
            Stream.of(res.warnings).filter(isFromIntern).forEach(warningsAndErrors::add);
            return warningsAndErrors;
        }
        catch (RuntimeException r) {
            try {
                return Collections.singletonList(JSError.make((DiagnosticType)DiagnosticType.error((String)"ERR_COMPILE_FAILURE", (String)("Cannot compile due to exception: " + Throwables.getStackTraceAsString((Throwable)r))), (String[])new String[0]));
            }
            catch (RuntimeException re) {
                return Collections.singletonList(JSError.make((DiagnosticType)DiagnosticType.error((String)"ERR_COMPILE_FAILURE", (String)("Cannot compile due to exception: " + r.getMessage().replaceAll("[{}]", ""))), (String[])new String[0]));
            }
        }
    }

    public static CompilerOptions createCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        options.setNewTypeInference(true);
        options.setContinueAfterErrors(true);
        options.setCheckSymbols(true);
        options.setCheckSuspiciousCode(false);
        options.setInferTypes(true);
        options.setInferConst(true);
        options.setClosurePass(true);
        options.setPreserveDetailedSourceInfo(true);
        options.setSkipNonTranspilationPasses(false);
        options.setIncrementalChecks(CompilerOptions.IncrementalCheckMode.OFF);
        options.setCheckTypes(true);
        options.setChecksOnly(true);
        return options;
    }
}

