/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.datastorage.postgres;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DisableAutocommitDatasource
implements DataSource {
    private final DataSource dataSource;

    public DisableAutocommitDatasource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.dataSource.getConnection(username, password);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        DataSource unwrapped;
        if (iface.isAssignableFrom(this.dataSource.getClass())) {
            unwrapped = this.dataSource;
            if (this.dataSource.isWrapperFor(iface)) {
                unwrapped = this.dataSource.unwrap(iface);
            }
        } else {
            unwrapped = this.dataSource.unwrap(iface);
        }
        return (T)unwrapped;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.dataSource.getClass()) || this.dataSource.isWrapperFor(iface);
    }
}

