/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.datastorage.postgres;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.io.CharStreams;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.DataAndId;
import io.github.factoryfx.factory.storage.DataAndStoredMetadata;
import io.github.factoryfx.factory.storage.DataStorage;
import io.github.factoryfx.factory.storage.DataStoragePatcher;
import io.github.factoryfx.factory.storage.DataUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdateMetadata;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import io.github.factoryfx.factory.storage.migration.MigrationManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.sql.DataSource;

public class PostgresDataStorage<R extends FactoryBase<?, R>, S>
implements DataStorage<R, S> {
    private final R initialData;
    private final DataSource dataSource;
    private final MigrationManager<R, S> migrationManager;
    private final SimpleObjectMapper objectMapper;
    private boolean tablesAreAvailable;

    public PostgresDataStorage(DataSource dataSource, R initialDataParam, MigrationManager<R, S> migrationManager, SimpleObjectMapper objectMapper) {
        this.dataSource = dataSource;
        this.initialData = initialDataParam;
        this.migrationManager = migrationManager;
        this.objectMapper = objectMapper;
    }

    /*
     * Exception decompiling
     */
    public R getHistoryData(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Collection<StoredDataMetadata<S>> getHistoryDataList() {
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<StoredDataMetadata<S>> arrayList;
            block22: {
                PreparedStatement pstmt = connection.prepareStatement("select cast (metadata as text) as metadata from configuration");
                try {
                    ArrayList<StoredDataMetadata<S>> ret = new ArrayList<StoredDataMetadata<S>>();
                    try (ResultSet rs = pstmt.executeQuery();){
                        this.ensureTablesAreAvailable(connection);
                        while (rs.next()) {
                            ret.add(this.migrationManager.readStoredFactoryMetadata(rs.getString(1)));
                        }
                    }
                    arrayList = ret;
                    if (pstmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read current factory", e);
        }
    }

    /*
     * Exception decompiling
     */
    public DataAndId<R> getCurrentData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateCurrentData(DataUpdate<R> update, S changeSummary) {
        StoredDataMetadata metadata = update.createUpdateStoredDataMetadata(changeSummary, this.getCurrentData().id);
        this.update(update.root, metadata);
    }

    public void patchAll(DataStoragePatcher consumer) {
        throw new UnsupportedOperationException();
    }

    public void patchCurrentData(DataStoragePatcher consumer) {
        String dataString = null;
        String metadataString = null;
        this.getCurrentData();
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement pstmt = connection.prepareStatement("select cast (root as text) as root, cast (metadata as text) as metadata from currentconfiguration");
                 ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    dataString = rs.getString(1);
                    metadataString = rs.getString(2);
                }
            }
            JsonNode data = this.objectMapper.readTree(dataString);
            JsonNode metadata = this.objectMapper.readTree(metadataString);
            consumer.patch(data, metadata);
            try (PreparedStatement pstmt = connection.prepareStatement("update currentconfiguration set root = cast (? as json), metadata = cast (? as json)");){
                pstmt.setString(1, this.objectMapper.writeTree(data));
                pstmt.setString(2, this.objectMapper.writeTree(metadata));
                pstmt.execute();
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read current factory", e);
        }
    }

    private void update(R update, StoredDataMetadata<S> metadata) {
        try (Connection connection = this.dataSource.getConnection();){
            this.ensureTablesAreAvailable(connection);
            this.updateCurrentFactory(connection, new DataAndStoredMetadata(update, metadata));
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot update current factory", e);
        }
    }

    private void updateCurrentFactory(Connection connection, DataAndStoredMetadata<R, S> update) throws SQLException {
        try (PreparedStatement pstmtlockConfiguration = connection.prepareStatement("lock table currentconfiguration in exclusive mode");){
            pstmtlockConfiguration.execute();
        }
        long createdAt = System.currentTimeMillis();
        boolean firstEntry = false;
        try (PreparedStatement selectMaxCreatedAt = connection.prepareStatement("select max(createdAt) as ts from currentconfiguration");
             ResultSet maxCreatedAtRs = selectMaxCreatedAt.executeQuery();){
            Timestamp timestamp = null;
            if (maxCreatedAtRs.next()) {
                timestamp = maxCreatedAtRs.getTimestamp(1);
            }
            if (timestamp != null) {
                createdAt = Math.max(createdAt, timestamp.getTime() + 1L);
            } else {
                firstEntry = true;
            }
        }
        Timestamp createdAtTimestamp = new Timestamp(createdAt);
        try (PreparedStatement pstmtInsertConfigurationMetadata = connection.prepareStatement("insert into configurationmetadata (metadata, createdAt, id) values (cast (? as json), ?, ?)");){
            pstmtInsertConfigurationMetadata.setString(1, this.migrationManager.writeStorageMetadata(update.metadata));
            pstmtInsertConfigurationMetadata.setTimestamp(2, createdAtTimestamp);
            pstmtInsertConfigurationMetadata.setString(3, update.metadata.id);
            pstmtInsertConfigurationMetadata.execute();
        }
        try (PreparedStatement pstmtInsertConfiguration = connection.prepareStatement("insert into configuration (root, metadata, createdAt, id) values (cast (? as json), cast (? as json), ?, ?)");){
            this.setValues(update, createdAtTimestamp, pstmtInsertConfiguration);
        }
        try (PreparedStatement pstmtUpdateCurrentConfiguraion = firstEntry ? connection.prepareStatement("insert into currentconfiguration (root,metadata,createdAt,id) values (cast (? as json), cast (? as json), ?, ?)") : connection.prepareStatement("update currentconfiguration set root = cast (? as json), metadata = cast (? as json), createdAt = ?, id = ?");){
            this.setValues(update, createdAtTimestamp, pstmtUpdateCurrentConfiguraion);
        }
    }

    private void setValues(DataAndStoredMetadata<R, S> update, Timestamp createdAtTimestamp, PreparedStatement pstmt) throws SQLException {
        pstmt.setString(1, this.migrationManager.write(update.root));
        pstmt.setString(2, this.migrationManager.writeStorageMetadata(update.metadata));
        pstmt.setTimestamp(3, createdAtTimestamp);
        pstmt.setString(4, update.metadata.id);
        pstmt.execute();
    }

    private void ensureTablesAreAvailable(Connection connection) {
        if (!this.tablesAreAvailable) {
            try (ResultSet checkTablesExist = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), "currentconfiguration", null);){
                if (!checkTablesExist.next()) {
                    this.createTables(connection);
                    connection.commit();
                    this.tablesAreAvailable = true;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void createTables(Connection connection) {
        try (Statement stmt = connection.createStatement();){
            stmt.execute(CharStreams.toString((Readable)new InputStreamReader(this.getClass().getResourceAsStream("createConfigurationtables.sql"), StandardCharsets.UTF_8)));
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Collection<ScheduledUpdateMetadata> getFutureDataList() {
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<ScheduledUpdateMetadata> arrayList;
            block22: {
                PreparedStatement pstmt = connection.prepareStatement("select cast (metadata as text) as metadata from futureconfigurationmetadata");
                try {
                    ArrayList<ScheduledUpdateMetadata> ret = new ArrayList<ScheduledUpdateMetadata>();
                    try (ResultSet rs = pstmt.executeQuery();){
                        while (rs.next()) {
                            ret.add(this.migrationManager.readScheduledFactoryMetadata(rs.getString(1)));
                        }
                    }
                    arrayList = ret;
                    if (pstmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read future factories", e);
        }
    }

    public void deleteFutureData(String id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement pstmtDeleteMetadata = connection.prepareStatement("delete from futureconfigurationmetadata where id = ?");
             PreparedStatement pstmtDeleteConfiguration = connection.prepareStatement("delete from futureconfiguration where id = ?");){
            pstmtDeleteMetadata.setString(1, id);
            pstmtDeleteMetadata.executeUpdate();
            pstmtDeleteConfiguration.setString(1, id);
            pstmtDeleteConfiguration.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot delete future factory", e);
        }
    }

    /*
     * Exception decompiling
     */
    public R getFutureData(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addFutureData(ScheduledUpdate<R> futureFactory) {
        ScheduledUpdateMetadata scheduledUpdateMetadata = new ScheduledUpdateMetadata(UUID.randomUUID().toString(), futureFactory.user, futureFactory.comment, futureFactory.scheduled, futureFactory.root.internal().createDataStorageMetadataDictionaryFromRoot());
        try (Connection connection = this.dataSource.getConnection();){
            this.ensureTablesAreAvailable(connection);
            long createdAt = System.currentTimeMillis();
            Timestamp createdAtTimestamp = new Timestamp(createdAt);
            try (PreparedStatement pstmtInsertConfigurationMetadata = connection.prepareStatement("insert into futureconfigurationmetadata (metadata, createdAt, id) values (cast (? as json), ?, ?)");){
                pstmtInsertConfigurationMetadata.setString(1, this.migrationManager.writeScheduledUpdateMetadata(scheduledUpdateMetadata));
                pstmtInsertConfigurationMetadata.setTimestamp(2, createdAtTimestamp);
                pstmtInsertConfigurationMetadata.setString(3, scheduledUpdateMetadata.id);
                pstmtInsertConfigurationMetadata.execute();
            }
            try (PreparedStatement pstmtInsertConfiguration = connection.prepareStatement("insert into futureconfiguration (root, metadata, createdAt, id) values (cast (? as json), cast (? as json), ?, ?)");){
                pstmtInsertConfiguration.setString(1, this.migrationManager.write(futureFactory.root));
                pstmtInsertConfiguration.setString(2, this.migrationManager.writeScheduledUpdateMetadata(scheduledUpdateMetadata));
                pstmtInsertConfiguration.setTimestamp(3, createdAtTimestamp);
                pstmtInsertConfiguration.setString(4, scheduledUpdateMetadata.id);
                pstmtInsertConfiguration.execute();
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot add future factory", e);
        }
    }
}

