/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="AlluxioCompTemplateSpec is a description of the Alluxio commponents")
public class AlluxioCompTemplateSpec {
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="env")
    private Map<String, String> env = null;
    @SerializedName(value="jvmOptions")
    private List<String> jvmOptions = null;
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    @SerializedName(value="ports")
    private Map<String, Integer> ports = null;
    @SerializedName(value="properties")
    private Map<String, String> properties = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;

    public AlluxioCompTemplateSpec enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Enabled or Disabled for the components. For now, only  API Gateway is enabled or disabled.")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AlluxioCompTemplateSpec env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public AlluxioCompTemplateSpec putEnvItem(String key, String envItem) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, envItem);
        return this;
    }

    @ApiModelProperty(value="Environment variables that will be used by Alluxio component. <br>")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public AlluxioCompTemplateSpec jvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public AlluxioCompTemplateSpec addJvmOptionsItem(String jvmOptionsItem) {
        if (this.jvmOptions == null) {
            this.jvmOptions = new ArrayList<String>();
        }
        this.jvmOptions.add(jvmOptionsItem);
        return this;
    }

    @ApiModelProperty(value="Options for JVM")
    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public AlluxioCompTemplateSpec nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public AlluxioCompTemplateSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @ApiModelProperty(value="NodeSelector is a selector which must be true for the master to fit on a node")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public AlluxioCompTemplateSpec ports(Map<String, Integer> ports) {
        this.ports = ports;
        return this;
    }

    public AlluxioCompTemplateSpec putPortsItem(String key, Integer portsItem) {
        if (this.ports == null) {
            this.ports = new HashMap<String, Integer>();
        }
        this.ports.put(key, portsItem);
        return this;
    }

    @ApiModelProperty(value="Ports used by Alluxio(e.g. rpc: 19998 for master)")
    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

    public AlluxioCompTemplateSpec properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public AlluxioCompTemplateSpec putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Configurable properties for the Alluxio component. <br> Refer to <a href=\"https://docs.alluxio.io/os/user/stable/en/reference/Properties-List.html\">Alluxio Configuration Properties</a> for more info")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public AlluxioCompTemplateSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Replicas is the desired number of replicas of the given template. If unspecified, defaults to 1. replicas is the min replicas of dataset in the cluster")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public AlluxioCompTemplateSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Resources that will be requested by the Alluxio component. <br> <br> Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlluxioCompTemplateSpec alluxioCompTemplateSpec = (AlluxioCompTemplateSpec)o;
        return Objects.equals(this.enabled, alluxioCompTemplateSpec.enabled) && Objects.equals(this.env, alluxioCompTemplateSpec.env) && Objects.equals(this.jvmOptions, alluxioCompTemplateSpec.jvmOptions) && Objects.equals(this.nodeSelector, alluxioCompTemplateSpec.nodeSelector) && Objects.equals(this.ports, alluxioCompTemplateSpec.ports) && Objects.equals(this.properties, alluxioCompTemplateSpec.properties) && Objects.equals(this.replicas, alluxioCompTemplateSpec.replicas) && Objects.equals(this.resources, alluxioCompTemplateSpec.resources);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.env, this.jvmOptions, this.nodeSelector, this.ports, this.properties, this.replicas, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlluxioCompTemplateSpec {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    jvmOptions: ").append(this.toIndentedString(this.jvmOptions)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

