/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.TargetDataset;
import com.github.fluid_cloudnative.fluid.TargetPath;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DataLoadSpec defines the desired state of DataLoad")
public class DataLoadSpec {
    @SerializedName(value="dataset")
    private TargetDataset dataset = null;
    @SerializedName(value="loadMetadata")
    private Boolean loadMetadata = null;
    @SerializedName(value="target")
    private List<TargetPath> target = null;

    public DataLoadSpec dataset(TargetDataset dataset) {
        this.dataset = dataset;
        return this;
    }

    @ApiModelProperty(value="Dataset defines the target dataset of the DataLoad")
    public TargetDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(TargetDataset dataset) {
        this.dataset = dataset;
    }

    public DataLoadSpec loadMetadata(Boolean loadMetadata) {
        this.loadMetadata = loadMetadata;
        return this;
    }

    @ApiModelProperty(value="LoadMetadata specifies if the dataload job should load metadata")
    public Boolean isLoadMetadata() {
        return this.loadMetadata;
    }

    public void setLoadMetadata(Boolean loadMetadata) {
        this.loadMetadata = loadMetadata;
    }

    public DataLoadSpec target(List<TargetPath> target) {
        this.target = target;
        return this;
    }

    public DataLoadSpec addTargetItem(TargetPath targetItem) {
        if (this.target == null) {
            this.target = new ArrayList<TargetPath>();
        }
        this.target.add(targetItem);
        return this;
    }

    @ApiModelProperty(value="Target defines target paths that needs to be loaded")
    public List<TargetPath> getTarget() {
        return this.target;
    }

    public void setTarget(List<TargetPath> target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataLoadSpec dataLoadSpec = (DataLoadSpec)o;
        return Objects.equals(this.dataset, dataLoadSpec.dataset) && Objects.equals(this.loadMetadata, dataLoadSpec.loadMetadata) && Objects.equals(this.target, dataLoadSpec.target);
    }

    public int hashCode() {
        return Objects.hash(this.dataset, this.loadMetadata, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataLoadSpec {\n");
        sb.append("    dataset: ").append(this.toIndentedString(this.dataset)).append("\n");
        sb.append("    loadMetadata: ").append(this.toIndentedString(this.loadMetadata)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

