/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.proto.Meta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Condition describes the state of the cache at a certain point.")
public class DatasetCondition {
    @SerializedName(value="lastTransitionTime")
    private Meta.Time lastTransitionTime = null;
    @SerializedName(value="lastUpdateTime")
    private Meta.Time lastUpdateTime = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="type")
    private String type = null;

    public DatasetCondition lastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @ApiModelProperty(value="Last time the condition transitioned from one status to another.")
    public Meta.Time getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public DatasetCondition lastUpdateTime(Meta.Time lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @ApiModelProperty(value="The last time this condition was updated.")
    public Meta.Time getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Meta.Time lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public DatasetCondition message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A human readable message indicating details about the transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DatasetCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public DatasetCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DatasetCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of cache condition.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetCondition datasetCondition = (DatasetCondition)o;
        return Objects.equals(this.lastTransitionTime, datasetCondition.lastTransitionTime) && Objects.equals(this.lastUpdateTime, datasetCondition.lastUpdateTime) && Objects.equals(this.message, datasetCondition.message) && Objects.equals(this.reason, datasetCondition.reason) && Objects.equals(this.status, datasetCondition.status) && Objects.equals(this.type, datasetCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.lastUpdateTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

