/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.DatasetCondition;
import com.github.fluid_cloudnative.fluid.HCFSStatus;
import com.github.fluid_cloudnative.fluid.Runtime;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="DatasetStatus defines the observed state of Dataset")
public class DatasetStatus {
    @SerializedName(value="cacheStates")
    private Map<String, String> cacheStates = null;
    @SerializedName(value="conditions")
    private List<DatasetCondition> conditions = new ArrayList<DatasetCondition>();
    @SerializedName(value="dataBackupRef")
    private String dataBackupRef = null;
    @SerializedName(value="dataLoadRef")
    private String dataLoadRef = null;
    @SerializedName(value="fileNum")
    private String fileNum = null;
    @SerializedName(value="hcfs")
    private HCFSStatus hcfs = null;
    @SerializedName(value="phase")
    private String phase = null;
    @SerializedName(value="runtimes")
    private List<Runtime> runtimes = null;
    @SerializedName(value="ufsTotal")
    private String ufsTotal = null;

    public DatasetStatus cacheStates(Map<String, String> cacheStates) {
        this.cacheStates = cacheStates;
        return this;
    }

    public DatasetStatus putCacheStatesItem(String key, String cacheStatesItem) {
        if (this.cacheStates == null) {
            this.cacheStates = new HashMap<String, String>();
        }
        this.cacheStates.put(key, cacheStatesItem);
        return this;
    }

    @ApiModelProperty(value="CacheStatus represents the total resources of the dataset.")
    public Map<String, String> getCacheStates() {
        return this.cacheStates;
    }

    public void setCacheStates(Map<String, String> cacheStates) {
        this.cacheStates = cacheStates;
    }

    public DatasetStatus conditions(List<DatasetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public DatasetStatus addConditionsItem(DatasetCondition conditionsItem) {
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Conditions is an array of current observed conditions.")
    public List<DatasetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<DatasetCondition> conditions) {
        this.conditions = conditions;
    }

    public DatasetStatus dataBackupRef(String dataBackupRef) {
        this.dataBackupRef = dataBackupRef;
        return this;
    }

    @ApiModelProperty(value="DataBackupRef specifies the running Backup job that targets this Dataset. This is mainly used as a lock to prevent concurrent DataBackup jobs.")
    public String getDataBackupRef() {
        return this.dataBackupRef;
    }

    public void setDataBackupRef(String dataBackupRef) {
        this.dataBackupRef = dataBackupRef;
    }

    public DatasetStatus dataLoadRef(String dataLoadRef) {
        this.dataLoadRef = dataLoadRef;
        return this;
    }

    @ApiModelProperty(value="DataLoadRef specifies the running DataLoad job that targets this Dataset. This is mainly used as a lock to prevent concurrent DataLoad jobs.")
    public String getDataLoadRef() {
        return this.dataLoadRef;
    }

    public void setDataLoadRef(String dataLoadRef) {
        this.dataLoadRef = dataLoadRef;
    }

    public DatasetStatus fileNum(String fileNum) {
        this.fileNum = fileNum;
        return this;
    }

    @ApiModelProperty(value="FileNum represents the file numbers of the dataset")
    public String getFileNum() {
        return this.fileNum;
    }

    public void setFileNum(String fileNum) {
        this.fileNum = fileNum;
    }

    public DatasetStatus hcfs(HCFSStatus hcfs) {
        this.hcfs = hcfs;
        return this;
    }

    @ApiModelProperty(value="HCFSStatus represents hcfs info")
    public HCFSStatus getHcfs() {
        return this.hcfs;
    }

    public void setHcfs(HCFSStatus hcfs) {
        this.hcfs = hcfs;
    }

    public DatasetStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @ApiModelProperty(value="Dataset Phase. One of the four phases: `Pending`, `Bound`, `NotBound` and `Failed`")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public DatasetStatus runtimes(List<Runtime> runtimes) {
        this.runtimes = runtimes;
        return this;
    }

    public DatasetStatus addRuntimesItem(Runtime runtimesItem) {
        if (this.runtimes == null) {
            this.runtimes = new ArrayList<Runtime>();
        }
        this.runtimes.add(runtimesItem);
        return this;
    }

    @ApiModelProperty(value="Runtimes for supporting dataset")
    public List<Runtime> getRuntimes() {
        return this.runtimes;
    }

    public void setRuntimes(List<Runtime> runtimes) {
        this.runtimes = runtimes;
    }

    public DatasetStatus ufsTotal(String ufsTotal) {
        this.ufsTotal = ufsTotal;
        return this;
    }

    @ApiModelProperty(value="Total in GB of dataset in the cluster")
    public String getUfsTotal() {
        return this.ufsTotal;
    }

    public void setUfsTotal(String ufsTotal) {
        this.ufsTotal = ufsTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetStatus datasetStatus = (DatasetStatus)o;
        return Objects.equals(this.cacheStates, datasetStatus.cacheStates) && Objects.equals(this.conditions, datasetStatus.conditions) && Objects.equals(this.dataBackupRef, datasetStatus.dataBackupRef) && Objects.equals(this.dataLoadRef, datasetStatus.dataLoadRef) && Objects.equals(this.fileNum, datasetStatus.fileNum) && Objects.equals(this.hcfs, datasetStatus.hcfs) && Objects.equals(this.phase, datasetStatus.phase) && Objects.equals(this.runtimes, datasetStatus.runtimes) && Objects.equals(this.ufsTotal, datasetStatus.ufsTotal);
    }

    public int hashCode() {
        return Objects.hash(this.cacheStates, this.conditions, this.dataBackupRef, this.dataLoadRef, this.fileNum, this.hcfs, this.phase, this.runtimes, this.ufsTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetStatus {\n");
        sb.append("    cacheStates: ").append(this.toIndentedString(this.cacheStates)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    dataBackupRef: ").append(this.toIndentedString(this.dataBackupRef)).append("\n");
        sb.append("    dataLoadRef: ").append(this.toIndentedString(this.dataLoadRef)).append("\n");
        sb.append("    fileNum: ").append(this.toIndentedString(this.fileNum)).append("\n");
        sb.append("    hcfs: ").append(this.toIndentedString(this.hcfs)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    runtimes: ").append(this.toIndentedString(this.runtimes)).append("\n");
        sb.append("    ufsTotal: ").append(this.toIndentedString(this.ufsTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

