/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="JindoCompTemplateSpec is a description of the Jindo commponents")
public class JindoCompTemplateSpec {
    @SerializedName(value="env")
    private Map<String, String> env = null;
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    @SerializedName(value="ports")
    private Map<String, Integer> ports = null;
    @SerializedName(value="properties")
    private Map<String, String> properties = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;

    public JindoCompTemplateSpec env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public JindoCompTemplateSpec putEnvItem(String key, String envItem) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, envItem);
        return this;
    }

    @ApiModelProperty(value="Environment variables that will be used by Jindo component. <br>")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public JindoCompTemplateSpec nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public JindoCompTemplateSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @ApiModelProperty(value="NodeSelector is a selector which must be true for the master to fit on a node")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public JindoCompTemplateSpec ports(Map<String, Integer> ports) {
        this.ports = ports;
        return this;
    }

    public JindoCompTemplateSpec putPortsItem(String key, Integer portsItem) {
        if (this.ports == null) {
            this.ports = new HashMap<String, Integer>();
        }
        this.ports.put(key, portsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

    public JindoCompTemplateSpec properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public JindoCompTemplateSpec putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Configurable properties for the Jindo component. <br>")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public JindoCompTemplateSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Replicas is the desired number of replicas of the given template. If unspecified, defaults to 1. replicas is the min replicas of dataset in the cluster")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public JindoCompTemplateSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Resources that will be requested by the Jindo component. <br> <br> Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JindoCompTemplateSpec jindoCompTemplateSpec = (JindoCompTemplateSpec)o;
        return Objects.equals(this.env, jindoCompTemplateSpec.env) && Objects.equals(this.nodeSelector, jindoCompTemplateSpec.nodeSelector) && Objects.equals(this.ports, jindoCompTemplateSpec.ports) && Objects.equals(this.properties, jindoCompTemplateSpec.properties) && Objects.equals(this.replicas, jindoCompTemplateSpec.replicas) && Objects.equals(this.resources, jindoCompTemplateSpec.resources);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.nodeSelector, this.ports, this.properties, this.replicas, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JindoCompTemplateSpec {\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

