/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.EncryptOption;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Mount describes a mounting. <br> Refer to <a href=\"https://docs.alluxio.io/os/user/stable/en/ufs/S3.html\">Alluxio Storage Integrations</a> for more info")
public class Mount {
    @SerializedName(value="encryptOptions")
    private List<EncryptOption> encryptOptions = null;
    @SerializedName(value="mountPoint")
    private String mountPoint = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="options")
    private Map<String, String> options = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="shared")
    private Boolean shared = null;

    public Mount encryptOptions(List<EncryptOption> encryptOptions) {
        this.encryptOptions = encryptOptions;
        return this;
    }

    public Mount addEncryptOptionsItem(EncryptOption encryptOptionsItem) {
        if (this.encryptOptions == null) {
            this.encryptOptions = new ArrayList<EncryptOption>();
        }
        this.encryptOptions.add(encryptOptionsItem);
        return this;
    }

    @ApiModelProperty(value="The secret information")
    public List<EncryptOption> getEncryptOptions() {
        return this.encryptOptions;
    }

    public void setEncryptOptions(List<EncryptOption> encryptOptions) {
        this.encryptOptions = encryptOptions;
    }

    public Mount mountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
        return this;
    }

    @ApiModelProperty(value="MountPoint is the mount point of source.")
    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public Mount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of mount")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mount options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public Mount putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @ApiModelProperty(value="The Mount Options. <br> Refer to <a href=\"https://docs.alluxio.io/os/user/stable/en/reference/Properties-List.html\">Mount Options</a>.  <br> The option has Prefix 'fs.' And you can Learn more from <a href=\"https://docs.alluxio.io/os/user/stable/en/ufs/S3.html\">The Storage Integrations</a>")
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Mount path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="The path of mount, if not set will be /{Name}")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Mount readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to false (read-write).")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Mount shared(Boolean shared) {
        this.shared = shared;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to false (shared).")
    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mount mount = (Mount)o;
        return Objects.equals(this.encryptOptions, mount.encryptOptions) && Objects.equals(this.mountPoint, mount.mountPoint) && Objects.equals(this.name, mount.name) && Objects.equals(this.options, mount.options) && Objects.equals(this.path, mount.path) && Objects.equals(this.readOnly, mount.readOnly) && Objects.equals(this.shared, mount.shared);
    }

    public int hashCode() {
        return Objects.hash(this.encryptOptions, this.mountPoint, this.name, this.options, this.path, this.readOnly, this.shared);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Mount {\n");
        sb.append("    encryptOptions: ").append(this.toIndentedString(this.encryptOptions)).append("\n");
        sb.append("    mountPoint: ").append(this.toIndentedString(this.mountPoint)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

