/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Runtime describes a runtime to be used to support dataset")
public class Runtime {
    @SerializedName(value="category")
    private String category = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespace")
    private String namespace = null;
    @SerializedName(value="type")
    private String type = null;

    public Runtime category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="Category the runtime object belongs to (e.g. Accelerate)")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Runtime name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the runtime object")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Runtime namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="Namespace of the runtime object")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Runtime type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Runtime object's type (e.g. Alluxio)")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Runtime runtime = (Runtime)o;
        return Objects.equals(this.category, runtime.category) && Objects.equals(this.name, runtime.name) && Objects.equals(this.namespace, runtime.namespace) && Objects.equals(this.type, runtime.type);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.name, this.namespace, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Runtime {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

