/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.APIGatewayStatus;
import com.github.fluid_cloudnative.fluid.RuntimeCondition;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="RuntimeStatus defines the observed state of Runtime")
public class RuntimeStatus {
    @SerializedName(value="apiGateway")
    private APIGatewayStatus apiGateway = null;
    @SerializedName(value="cacheStates")
    private Map<String, String> cacheStates = null;
    @SerializedName(value="conditions")
    private List<RuntimeCondition> conditions = null;
    @SerializedName(value="currentFuseNumberScheduled")
    private Integer currentFuseNumberScheduled = null;
    @SerializedName(value="currentMasterNumberScheduled")
    private Integer currentMasterNumberScheduled = null;
    @SerializedName(value="currentWorkerNumberScheduled")
    private Integer currentWorkerNumberScheduled = null;
    @SerializedName(value="desiredFuseNumberScheduled")
    private Integer desiredFuseNumberScheduled = null;
    @SerializedName(value="desiredMasterNumberScheduled")
    private Integer desiredMasterNumberScheduled = null;
    @SerializedName(value="desiredWorkerNumberScheduled")
    private Integer desiredWorkerNumberScheduled = null;
    @SerializedName(value="fuseNumberAvailable")
    private Integer fuseNumberAvailable = null;
    @SerializedName(value="fuseNumberReady")
    private Integer fuseNumberReady = null;
    @SerializedName(value="fuseNumberUnavailable")
    private Integer fuseNumberUnavailable = null;
    @SerializedName(value="fusePhase")
    private String fusePhase = null;
    @SerializedName(value="fuseReason")
    private String fuseReason = null;
    @SerializedName(value="masterNumberReady")
    private Integer masterNumberReady = null;
    @SerializedName(value="masterPhase")
    private String masterPhase = null;
    @SerializedName(value="masterReason")
    private String masterReason = null;
    @SerializedName(value="selector")
    private String selector = null;
    @SerializedName(value="setupDuration")
    private String setupDuration = null;
    @SerializedName(value="valueFile")
    private String valueFile = null;
    @SerializedName(value="workerNumberAvailable")
    private Integer workerNumberAvailable = null;
    @SerializedName(value="workerNumberReady")
    private Integer workerNumberReady = null;
    @SerializedName(value="workerNumberUnavailable")
    private Integer workerNumberUnavailable = null;
    @SerializedName(value="workerPhase")
    private String workerPhase = null;
    @SerializedName(value="workerReason")
    private String workerReason = null;

    public RuntimeStatus apiGateway(APIGatewayStatus apiGateway) {
        this.apiGateway = apiGateway;
        return this;
    }

    @ApiModelProperty(value="APIGatewayStatus represents rest api gateway status")
    public APIGatewayStatus getApiGateway() {
        return this.apiGateway;
    }

    public void setApiGateway(APIGatewayStatus apiGateway) {
        this.apiGateway = apiGateway;
    }

    public RuntimeStatus cacheStates(Map<String, String> cacheStates) {
        this.cacheStates = cacheStates;
        return this;
    }

    public RuntimeStatus putCacheStatesItem(String key, String cacheStatesItem) {
        if (this.cacheStates == null) {
            this.cacheStates = new HashMap<String, String>();
        }
        this.cacheStates.put(key, cacheStatesItem);
        return this;
    }

    @ApiModelProperty(value="CacheStatus represents the total resources of the dataset.")
    public Map<String, String> getCacheStates() {
        return this.cacheStates;
    }

    public void setCacheStates(Map<String, String> cacheStates) {
        this.cacheStates = cacheStates;
    }

    public RuntimeStatus conditions(List<RuntimeCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public RuntimeStatus addConditionsItem(RuntimeCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<RuntimeCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Represents the latest available observations of a ddc runtime's current state.")
    public List<RuntimeCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<RuntimeCondition> conditions) {
        this.conditions = conditions;
    }

    public RuntimeStatus currentFuseNumberScheduled(Integer currentFuseNumberScheduled) {
        this.currentFuseNumberScheduled = currentFuseNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that can be running the runtime Fuse pod (including nodes correctly running the runtime Fuse pod).")
    public Integer getCurrentFuseNumberScheduled() {
        return this.currentFuseNumberScheduled;
    }

    public void setCurrentFuseNumberScheduled(Integer currentFuseNumberScheduled) {
        this.currentFuseNumberScheduled = currentFuseNumberScheduled;
    }

    public RuntimeStatus currentMasterNumberScheduled(Integer currentMasterNumberScheduled) {
        this.currentMasterNumberScheduled = currentMasterNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the runtime pod (including nodes correctly running the runtime master pod).")
    public Integer getCurrentMasterNumberScheduled() {
        return this.currentMasterNumberScheduled;
    }

    public void setCurrentMasterNumberScheduled(Integer currentMasterNumberScheduled) {
        this.currentMasterNumberScheduled = currentMasterNumberScheduled;
    }

    public RuntimeStatus currentWorkerNumberScheduled(Integer currentWorkerNumberScheduled) {
        this.currentWorkerNumberScheduled = currentWorkerNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that can be running the runtime worker pod (including nodes correctly running the runtime worker pod).")
    public Integer getCurrentWorkerNumberScheduled() {
        return this.currentWorkerNumberScheduled;
    }

    public void setCurrentWorkerNumberScheduled(Integer currentWorkerNumberScheduled) {
        this.currentWorkerNumberScheduled = currentWorkerNumberScheduled;
    }

    public RuntimeStatus desiredFuseNumberScheduled(Integer desiredFuseNumberScheduled) {
        this.desiredFuseNumberScheduled = desiredFuseNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the runtime Fuse pod (including nodes correctly running the runtime Fuse pod).")
    public Integer getDesiredFuseNumberScheduled() {
        return this.desiredFuseNumberScheduled;
    }

    public void setDesiredFuseNumberScheduled(Integer desiredFuseNumberScheduled) {
        this.desiredFuseNumberScheduled = desiredFuseNumberScheduled;
    }

    public RuntimeStatus desiredMasterNumberScheduled(Integer desiredMasterNumberScheduled) {
        this.desiredMasterNumberScheduled = desiredMasterNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the runtime pod (including nodes correctly running the runtime master pod).")
    public Integer getDesiredMasterNumberScheduled() {
        return this.desiredMasterNumberScheduled;
    }

    public void setDesiredMasterNumberScheduled(Integer desiredMasterNumberScheduled) {
        this.desiredMasterNumberScheduled = desiredMasterNumberScheduled;
    }

    public RuntimeStatus desiredWorkerNumberScheduled(Integer desiredWorkerNumberScheduled) {
        this.desiredWorkerNumberScheduled = desiredWorkerNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the runtime worker pod (including nodes correctly running the runtime worker pod).")
    public Integer getDesiredWorkerNumberScheduled() {
        return this.desiredWorkerNumberScheduled;
    }

    public void setDesiredWorkerNumberScheduled(Integer desiredWorkerNumberScheduled) {
        this.desiredWorkerNumberScheduled = desiredWorkerNumberScheduled;
    }

    public RuntimeStatus fuseNumberAvailable(Integer fuseNumberAvailable) {
        this.fuseNumberAvailable = fuseNumberAvailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the runtime Fuse pod and have one or more of the runtime Fuse pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getFuseNumberAvailable() {
        return this.fuseNumberAvailable;
    }

    public void setFuseNumberAvailable(Integer fuseNumberAvailable) {
        this.fuseNumberAvailable = fuseNumberAvailable;
    }

    public RuntimeStatus fuseNumberReady(Integer fuseNumberReady) {
        this.fuseNumberReady = fuseNumberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the runtime Fuse pod and have one or more of the runtime Fuse pod running and ready.")
    public Integer getFuseNumberReady() {
        return this.fuseNumberReady;
    }

    public void setFuseNumberReady(Integer fuseNumberReady) {
        this.fuseNumberReady = fuseNumberReady;
    }

    public RuntimeStatus fuseNumberUnavailable(Integer fuseNumberUnavailable) {
        this.fuseNumberUnavailable = fuseNumberUnavailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the runtime fuse pod and have none of the runtime fuse pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getFuseNumberUnavailable() {
        return this.fuseNumberUnavailable;
    }

    public void setFuseNumberUnavailable(Integer fuseNumberUnavailable) {
        this.fuseNumberUnavailable = fuseNumberUnavailable;
    }

    public RuntimeStatus fusePhase(String fusePhase) {
        this.fusePhase = fusePhase;
        return this;
    }

    @ApiModelProperty(required=true, value="FusePhase is the Fuse running phase")
    public String getFusePhase() {
        return this.fusePhase;
    }

    public void setFusePhase(String fusePhase) {
        this.fusePhase = fusePhase;
    }

    public RuntimeStatus fuseReason(String fuseReason) {
        this.fuseReason = fuseReason;
        return this;
    }

    @ApiModelProperty(value="Reason for the condition's last transition.")
    public String getFuseReason() {
        return this.fuseReason;
    }

    public void setFuseReason(String fuseReason) {
        this.fuseReason = fuseReason;
    }

    public RuntimeStatus masterNumberReady(Integer masterNumberReady) {
        this.masterNumberReady = masterNumberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the runtime worker pod and have zero or more of the runtime master pod running and ready.")
    public Integer getMasterNumberReady() {
        return this.masterNumberReady;
    }

    public void setMasterNumberReady(Integer masterNumberReady) {
        this.masterNumberReady = masterNumberReady;
    }

    public RuntimeStatus masterPhase(String masterPhase) {
        this.masterPhase = masterPhase;
        return this;
    }

    @ApiModelProperty(required=true, value="MasterPhase is the master running phase")
    public String getMasterPhase() {
        return this.masterPhase;
    }

    public void setMasterPhase(String masterPhase) {
        this.masterPhase = masterPhase;
    }

    public RuntimeStatus masterReason(String masterReason) {
        this.masterReason = masterReason;
        return this;
    }

    @ApiModelProperty(value="Reason for Master's condition transition")
    public String getMasterReason() {
        return this.masterReason;
    }

    public void setMasterReason(String masterReason) {
        this.masterReason = masterReason;
    }

    public RuntimeStatus selector(String selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="Selector is used for auto-scaling")
    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public RuntimeStatus setupDuration(String setupDuration) {
        this.setupDuration = setupDuration;
        return this;
    }

    @ApiModelProperty(value="Duration tell user how much time was spent to setup the runtime")
    public String getSetupDuration() {
        return this.setupDuration;
    }

    public void setSetupDuration(String setupDuration) {
        this.setupDuration = setupDuration;
    }

    public RuntimeStatus valueFile(String valueFile) {
        this.valueFile = valueFile;
        return this;
    }

    @ApiModelProperty(required=true, value="config map used to set configurations")
    public String getValueFile() {
        return this.valueFile;
    }

    public void setValueFile(String valueFile) {
        this.valueFile = valueFile;
    }

    public RuntimeStatus workerNumberAvailable(Integer workerNumberAvailable) {
        this.workerNumberAvailable = workerNumberAvailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the runtime worker pod and have one or more of the runtime worker pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getWorkerNumberAvailable() {
        return this.workerNumberAvailable;
    }

    public void setWorkerNumberAvailable(Integer workerNumberAvailable) {
        this.workerNumberAvailable = workerNumberAvailable;
    }

    public RuntimeStatus workerNumberReady(Integer workerNumberReady) {
        this.workerNumberReady = workerNumberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the runtime worker pod and have one or more of the runtime worker pod running and ready.")
    public Integer getWorkerNumberReady() {
        return this.workerNumberReady;
    }

    public void setWorkerNumberReady(Integer workerNumberReady) {
        this.workerNumberReady = workerNumberReady;
    }

    public RuntimeStatus workerNumberUnavailable(Integer workerNumberUnavailable) {
        this.workerNumberUnavailable = workerNumberUnavailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the runtime worker pod and have none of the runtime worker pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getWorkerNumberUnavailable() {
        return this.workerNumberUnavailable;
    }

    public void setWorkerNumberUnavailable(Integer workerNumberUnavailable) {
        this.workerNumberUnavailable = workerNumberUnavailable;
    }

    public RuntimeStatus workerPhase(String workerPhase) {
        this.workerPhase = workerPhase;
        return this;
    }

    @ApiModelProperty(required=true, value="WorkerPhase is the worker running phase")
    public String getWorkerPhase() {
        return this.workerPhase;
    }

    public void setWorkerPhase(String workerPhase) {
        this.workerPhase = workerPhase;
    }

    public RuntimeStatus workerReason(String workerReason) {
        this.workerReason = workerReason;
        return this;
    }

    @ApiModelProperty(value="Reason for Worker's condition transition")
    public String getWorkerReason() {
        return this.workerReason;
    }

    public void setWorkerReason(String workerReason) {
        this.workerReason = workerReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeStatus runtimeStatus = (RuntimeStatus)o;
        return Objects.equals(this.apiGateway, runtimeStatus.apiGateway) && Objects.equals(this.cacheStates, runtimeStatus.cacheStates) && Objects.equals(this.conditions, runtimeStatus.conditions) && Objects.equals(this.currentFuseNumberScheduled, runtimeStatus.currentFuseNumberScheduled) && Objects.equals(this.currentMasterNumberScheduled, runtimeStatus.currentMasterNumberScheduled) && Objects.equals(this.currentWorkerNumberScheduled, runtimeStatus.currentWorkerNumberScheduled) && Objects.equals(this.desiredFuseNumberScheduled, runtimeStatus.desiredFuseNumberScheduled) && Objects.equals(this.desiredMasterNumberScheduled, runtimeStatus.desiredMasterNumberScheduled) && Objects.equals(this.desiredWorkerNumberScheduled, runtimeStatus.desiredWorkerNumberScheduled) && Objects.equals(this.fuseNumberAvailable, runtimeStatus.fuseNumberAvailable) && Objects.equals(this.fuseNumberReady, runtimeStatus.fuseNumberReady) && Objects.equals(this.fuseNumberUnavailable, runtimeStatus.fuseNumberUnavailable) && Objects.equals(this.fusePhase, runtimeStatus.fusePhase) && Objects.equals(this.fuseReason, runtimeStatus.fuseReason) && Objects.equals(this.masterNumberReady, runtimeStatus.masterNumberReady) && Objects.equals(this.masterPhase, runtimeStatus.masterPhase) && Objects.equals(this.masterReason, runtimeStatus.masterReason) && Objects.equals(this.selector, runtimeStatus.selector) && Objects.equals(this.setupDuration, runtimeStatus.setupDuration) && Objects.equals(this.valueFile, runtimeStatus.valueFile) && Objects.equals(this.workerNumberAvailable, runtimeStatus.workerNumberAvailable) && Objects.equals(this.workerNumberReady, runtimeStatus.workerNumberReady) && Objects.equals(this.workerNumberUnavailable, runtimeStatus.workerNumberUnavailable) && Objects.equals(this.workerPhase, runtimeStatus.workerPhase) && Objects.equals(this.workerReason, runtimeStatus.workerReason);
    }

    public int hashCode() {
        return Objects.hash(this.apiGateway, this.cacheStates, this.conditions, this.currentFuseNumberScheduled, this.currentMasterNumberScheduled, this.currentWorkerNumberScheduled, this.desiredFuseNumberScheduled, this.desiredMasterNumberScheduled, this.desiredWorkerNumberScheduled, this.fuseNumberAvailable, this.fuseNumberReady, this.fuseNumberUnavailable, this.fusePhase, this.fuseReason, this.masterNumberReady, this.masterPhase, this.masterReason, this.selector, this.setupDuration, this.valueFile, this.workerNumberAvailable, this.workerNumberReady, this.workerNumberUnavailable, this.workerPhase, this.workerReason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimeStatus {\n");
        sb.append("    apiGateway: ").append(this.toIndentedString(this.apiGateway)).append("\n");
        sb.append("    cacheStates: ").append(this.toIndentedString(this.cacheStates)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentFuseNumberScheduled: ").append(this.toIndentedString(this.currentFuseNumberScheduled)).append("\n");
        sb.append("    currentMasterNumberScheduled: ").append(this.toIndentedString(this.currentMasterNumberScheduled)).append("\n");
        sb.append("    currentWorkerNumberScheduled: ").append(this.toIndentedString(this.currentWorkerNumberScheduled)).append("\n");
        sb.append("    desiredFuseNumberScheduled: ").append(this.toIndentedString(this.desiredFuseNumberScheduled)).append("\n");
        sb.append("    desiredMasterNumberScheduled: ").append(this.toIndentedString(this.desiredMasterNumberScheduled)).append("\n");
        sb.append("    desiredWorkerNumberScheduled: ").append(this.toIndentedString(this.desiredWorkerNumberScheduled)).append("\n");
        sb.append("    fuseNumberAvailable: ").append(this.toIndentedString(this.fuseNumberAvailable)).append("\n");
        sb.append("    fuseNumberReady: ").append(this.toIndentedString(this.fuseNumberReady)).append("\n");
        sb.append("    fuseNumberUnavailable: ").append(this.toIndentedString(this.fuseNumberUnavailable)).append("\n");
        sb.append("    fusePhase: ").append(this.toIndentedString(this.fusePhase)).append("\n");
        sb.append("    fuseReason: ").append(this.toIndentedString(this.fuseReason)).append("\n");
        sb.append("    masterNumberReady: ").append(this.toIndentedString(this.masterNumberReady)).append("\n");
        sb.append("    masterPhase: ").append(this.toIndentedString(this.masterPhase)).append("\n");
        sb.append("    masterReason: ").append(this.toIndentedString(this.masterReason)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    setupDuration: ").append(this.toIndentedString(this.setupDuration)).append("\n");
        sb.append("    valueFile: ").append(this.toIndentedString(this.valueFile)).append("\n");
        sb.append("    workerNumberAvailable: ").append(this.toIndentedString(this.workerNumberAvailable)).append("\n");
        sb.append("    workerNumberReady: ").append(this.toIndentedString(this.workerNumberReady)).append("\n");
        sb.append("    workerNumberUnavailable: ").append(this.toIndentedString(this.workerNumberUnavailable)).append("\n");
        sb.append("    workerPhase: ").append(this.toIndentedString(this.workerPhase)).append("\n");
        sb.append("    workerReason: ").append(this.toIndentedString(this.workerReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

